/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

public final class PoolConfiguration
implements Cloneable {
    private static final boolean DEFAULT_USE_BOUNDARY = true;
    private static final int DEFAULT_BOUNDARY_SIZE = 2000;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 150;
    private static final int DEFAULT_MINIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_KEEPALIVE_TIME = 300000;
    private static final WhenBlockedPolicy DEFAULT_WHEN_BLOCKED_POLICY = WhenBlockedPolicy.RUN;
    private static final int DEFAULT_STARTUP_SIZE = DEFAULT_MINIMUM_POOL_SIZE;
    private boolean useBoundary = true;
    private int boundarySize = 2000;
    private int maximumPoolSize = 150;
    private int minimumPoolSize = DEFAULT_MINIMUM_POOL_SIZE;
    private int keepAliveTime = 300000;
    private WhenBlockedPolicy whenBlockedPolicy = DEFAULT_WHEN_BLOCKED_POLICY;
    private int startUpSize = DEFAULT_MINIMUM_POOL_SIZE;

    public void setUseBoundary(boolean useBoundary) {
        this.useBoundary = useBoundary;
    }

    public boolean isUseBoundary() {
        return this.useBoundary;
    }

    public PoolConfiguration() {
        this(true, 2000, 150, DEFAULT_MINIMUM_POOL_SIZE, 300000, DEFAULT_WHEN_BLOCKED_POLICY, DEFAULT_STARTUP_SIZE);
    }

    public PoolConfiguration(boolean useBoundary, int boundarySize, int maximumPoolSize, int minimumPoolSize, int keepAliveTime, WhenBlockedPolicy whenBlockedPolicy, int startUpSize) {
        this.setUseBoundary(useBoundary);
        this.setBoundarySize(boundarySize);
        this.setMaximumPoolSize(maximumPoolSize);
        this.setMinimumPoolSize(minimumPoolSize);
        this.setKeepAliveTime(keepAliveTime);
        this.setWhenBlockedPolicy(whenBlockedPolicy);
        this.setStartUpSize(startUpSize);
    }

    public void setBoundarySize(int boundarySize) {
        this.boundarySize = boundarySize;
    }

    public int getBoundarySize() {
        return this.boundarySize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this.minimumPoolSize = minimumPoolSize;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setWhenBlockedPolicy(String whenBlockedPolicy) {
        if (whenBlockedPolicy != null) {
            WhenBlockedPolicy policy = WhenBlockedPolicy.valueOf(whenBlockedPolicy.trim().toUpperCase());
            this.setWhenBlockedPolicy(policy);
        } else {
            this.whenBlockedPolicy = WhenBlockedPolicy.RUN;
        }
    }

    public void setWhenBlockedPolicy(WhenBlockedPolicy whenBlockedPolicy) {
        this.whenBlockedPolicy = whenBlockedPolicy != null ? whenBlockedPolicy : WhenBlockedPolicy.RUN;
    }

    public WhenBlockedPolicy getWhenBlockedPolicy() {
        return this.whenBlockedPolicy;
    }

    public void setStartUpSize(int startUpSize) {
        this.startUpSize = startUpSize;
    }

    public int getStartUpSize() {
        return this.startUpSize;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("useBoundary = [" + this.isUseBoundary() + "] ");
        buf.append("boundarySize = [" + this.boundarySize + "] ");
        buf.append("maximumPoolSize = [" + this.maximumPoolSize + "] ");
        buf.append("minimumPoolSize = [" + this.minimumPoolSize + "] ");
        buf.append("keepAliveTime = [" + this.keepAliveTime + "] ");
        buf.append("whenBlockedPolicy = [" + (Object)((Object)this.getWhenBlockedPolicy()) + "] ");
        buf.append("startUpSize = [" + this.startUpSize + "]");
        return buf.toString();
    }

    public PoolConfiguration clone() {
        return new PoolConfiguration(this.isUseBoundary(), this.boundarySize, this.maximumPoolSize, this.minimumPoolSize, this.keepAliveTime, this.getWhenBlockedPolicy(), this.startUpSize);
    }

    public static enum WhenBlockedPolicy {
        ABORT,
        BLOCK,
        RUN,
        WAIT,
        DISCARDOLDEST;

    }
}

