/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "aligncircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true, "createcircle", true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private static int[] distributeNodes(PolarNode[] angles, int nodesCount) {
        int[] count = new int[angles.length];
        double[] width = new double[angles.length];
        double[] remainder = new double[angles.length];
        for (int i = 0; i < angles.length; ++i) {
            width[i] = angles[(i + 1) % angles.length].a - angles[i].a;
            if (!(width[i] < 0.0)) continue;
            int n = i;
            width[n] = width[n] + Math.PI * 2;
        }
        int assign = 0;
        for (int i = 0; i < angles.length; ++i) {
            double part = width[i] / 2.0 / Math.PI * (double)nodesCount;
            count[i] = (int)Math.floor(part);
            remainder[i] = part - (double)count[i];
            assign += count[i];
        }
        while (assign < nodesCount) {
            int imax = 0;
            for (int i = 1; i < angles.length; ++i) {
                if (!(remainder[i] > remainder[imax])) continue;
                imax = i;
            }
            int n = imax;
            count[n] = count[n] + 1;
            remainder[imax] = 0.0;
            ++assign;
        }
        return count;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EastNorth center;
        EastNorth n1;
        if (!this.isEnabled()) {
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection<OsmPrimitive> sel = ds.getSelected();
        List<Node> nodes = OsmPrimitive.getFilteredList(sel, Node.class);
        List<Way> ways = OsmPrimitive.getFilteredList(sel, Way.class);
        Way existingWay = null;
        if (nodes.isEmpty() && ways.size() == 1) {
            existingWay = ways.get(0);
            for (Node n : existingWay.getNodes()) {
                if (nodes.contains(n)) continue;
                nodes.add(n);
            }
        }
        if (nodes.size() < 2 || nodes.size() > 3) {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        if (nodes.size() == 2) {
            n1 = nodes.get(0).getEastNorth();
            EastNorth n2 = nodes.get(1).getEastNorth();
            center = n1.getCenter(n2);
        } else {
            center = Geometry.getCenter(nodes);
            if (center == null) {
                CreateCircleAction.notifyNodesNotOnCircle();
                return;
            }
        }
        n1 = nodes.get(0).getEastNorth();
        double r = n1.distance(center);
        LatLon ll1 = Main.getProjection().eastNorth2latlon(n1);
        LatLon ll2 = Main.getProjection().eastNorth2latlon(center);
        double radiusInMeters = ll1.greatCircleDistance(ll2);
        int numberOfNodesInCircle = (int)Math.ceil(6.0 * Math.pow(radiusInMeters, 0.5));
        if (numberOfNodesInCircle % 2 == 1) {
            ++numberOfNodesInCircle;
        }
        if (numberOfNodesInCircle < 6) {
            numberOfNodesInCircle = 6;
        }
        PolarNode[] angles = new PolarNode[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            angles[i] = new PolarNode(center, nodes.get(i));
        }
        Arrays.sort(angles, new PolarNodeComparator());
        int[] count = CreateCircleAction.distributeNodes(angles, numberOfNodesInCircle >= nodes.size() ? numberOfNodesInCircle - nodes.size() : 0);
        LinkedList<Command> cmds = new LinkedList<Command>();
        List<Node> nodesToAdd = new ArrayList<Node>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodesToAdd.add(angles[i].node);
            double delta = angles[(i + 1) % nodes.size()].a - angles[i].a;
            if (delta < 0.0) {
                delta += Math.PI * 2;
            }
            for (int j = 0; j < count[i]; ++j) {
                double alpha = angles[i].a + (double)(j + 1) * delta / (double)(count[i] + 1);
                double x = center.east() + r * Math.cos(alpha);
                double y = center.north() + r * Math.sin(alpha);
                LatLon ll = Main.getProjection().eastNorth2latlon(new EastNorth(x, y));
                if (ll.isOutSideWorld()) {
                    CreateCircleAction.notifyNodesNotOnCircle();
                    return;
                }
                Node n = new Node(ll);
                nodesToAdd.add(n);
                cmds.add(new AddCommand(ds, (OsmPrimitive)n));
            }
        }
        nodesToAdd.add((Node)nodesToAdd.get(0));
        nodesToAdd = existingWay != null && existingWay.getNodesCount() >= 3 ? CreateCircleAction.orderNodesByWay(nodesToAdd, existingWay) : CreateCircleAction.orderNodesByTrafficHand(nodesToAdd);
        if (existingWay == null) {
            Way newWay = new Way();
            newWay.setNodes(nodesToAdd);
            cmds.add(new AddCommand(ds, (OsmPrimitive)newWay));
        } else {
            Way newWay = new Way(existingWay);
            newWay.setNodes(nodesToAdd);
            cmds.add(new ChangeCommand(ds, (OsmPrimitive)existingWay, (OsmPrimitive)newWay));
        }
        MainApplication.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), cmds));
    }

    private static List<Node> orderNodesByTrafficHand(List<Node> nodes) {
        boolean rightHandTraffic = true;
        for (Node n : nodes) {
            if (RightAndLefthandTraffic.isRightHandTraffic(n.getCoor())) continue;
            rightHandTraffic = false;
            break;
        }
        if (rightHandTraffic == Geometry.isClockwise(nodes)) {
            Collections.reverse(nodes);
        }
        return nodes;
    }

    private static List<Node> orderNodesByWay(List<Node> nodes, Way way) {
        List<Node> wayNodes = way.getNodes();
        if (!way.isClosed()) {
            wayNodes.add(wayNodes.get(0));
        }
        if (Geometry.isClockwise(wayNodes) != Geometry.isClockwise(nodes)) {
            Collections.reverse(nodes);
        }
        return nodes;
    }

    private static void notifyNodesNotOnCircle() {
        new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private static class PolarNodeComparator
    implements Comparator<PolarNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PolarNodeComparator() {
        }

        @Override
        public int compare(PolarNode pc1, PolarNode pc2) {
            return Double.compare(pc1.a, pc2.a);
        }
    }

    private static class PolarNode {
        private final double a;
        private final Node node;

        PolarNode(EastNorth center, Node n) {
            this.a = PolarCoor.computeAngle(n.getEastNorth(), center);
            this.node = n;
        }
    }
}

