/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class GpxExportAction
extends DiskAccessAction {
    public GpxExportAction() {
        super(I18n.tr("Export to GPX...", new Object[0]), "exportgpx", I18n.tr("Export the data to GPX file.", new Object[0]), Shortcut.registerShortcut("file:exportgpx", I18n.tr("Export to GPX...", new Object[0]), 69, 5006));
        this.putValue("help", HelpUtil.ht("/Action/GpxExport"));
    }

    protected Layer getLayer() {
        Layer layer = this.getLayerManager().getActiveLayer();
        return layer instanceof GpxLayer || layer instanceof OsmDataLayer ? layer : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Layer layer = this.getLayer();
        if (layer == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to export. Get some data first.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        this.export(layer);
    }

    public void export(Layer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        File file = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Export GPX file", new Object[0]), GpxImporter.getFileFilter());
        if (file == null) {
            return;
        }
        for (FileExporter exporter : ExtensionFileFilter.getExporters()) {
            if (!exporter.acceptFile(file, layer)) continue;
            try {
                exporter.exportData(file, layer);
            }
            catch (IOException e) {
                Logging.error(e);
            }
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayer() != null);
    }
}

