/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;

public class CachedLatLon
extends LatLon {
    private static final long serialVersionUID = 1L;
    private EastNorth eastNorth;
    private transient Object cacheKey;

    public CachedLatLon(double lat, double lon) {
        super(lat, lon);
    }

    public CachedLatLon(LatLon coor) {
        super(coor.lat(), coor.lon());
        this.cacheKey = null;
    }

    public CachedLatLon(EastNorth eastNorth) {
        this(eastNorth, Main.getProjection());
    }

    private CachedLatLon(EastNorth eastNorth, Projection projection) {
        super(projection.eastNorth2latlon(eastNorth));
        this.cacheKey = projection.getCacheKey();
        this.eastNorth = eastNorth;
    }

    @Override
    public final EastNorth getEastNorth(Projecting projecting) {
        if (!Objects.equals(this.cacheKey, projecting.getCacheKey())) {
            this.cacheKey = projecting.getCacheKey();
            this.eastNorth = projecting.latlon2eastNorth(this);
        }
        return this.eastNorth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.eastNorth);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CachedLatLon other = (CachedLatLon)obj;
        return Objects.equals(this.eastNorth, other.eastNorth);
    }

    @Override
    public String toString() {
        return "CachedLatLon[lat=" + this.lat() + ",lon=" + this.lon() + ']';
    }
}

