/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.ListeningCollection;

public class GpxData
extends WithAttributes
implements Data {
    public File storageFile;
    public boolean fromServer;
    public String creator;
    private final ArrayList<GpxTrack> privateTracks = new ArrayList();
    private final ArrayList<GpxRoute> privateRoutes = new ArrayList();
    private final ArrayList<WayPoint> privateWaypoints = new ArrayList();
    private final GpxTrack.GpxTrackChangeListener proxy = e -> this.fireInvalidate();
    public final Collection<GpxTrack> tracks = new ListeningCollection<GpxTrack>(this.privateTracks, this::fireInvalidate){

        @Override
        protected void removed(GpxTrack cursor) {
            cursor.removeListener(GpxData.this.proxy);
            super.removed(cursor);
        }

        @Override
        protected void added(GpxTrack cursor) {
            super.added(cursor);
            cursor.addListener(GpxData.this.proxy);
        }
    };
    public final Collection<GpxRoute> routes = new ListeningCollection<GpxRoute>(this.privateRoutes, this::fireInvalidate);
    public final Collection<WayPoint> waypoints = new ListeningCollection<WayPoint>(this.privateWaypoints, this::fireInvalidate);
    public final Set<DataSource> dataSources = new HashSet<DataSource>();
    private final ListenerList<GpxDataChangeListener> listeners = ListenerList.create();

    public synchronized void mergeFrom(GpxData other) {
        if (this.storageFile == null && other.storageFile != null) {
            this.storageFile = other.storageFile;
        }
        this.fromServer = this.fromServer && other.fromServer;
        for (Map.Entry ent : other.attr.entrySet()) {
            String k = (String)ent.getKey();
            if ("meta.links".equals(k) && this.attr.containsKey("meta.links")) {
                Collection my = super.getCollection("meta.links");
                Collection their = (Collection)ent.getValue();
                my.addAll(their);
                continue;
            }
            this.put(k, ent.getValue());
        }
        other.privateTracks.forEach(this::addTrack);
        other.privateRoutes.forEach(this::addRoute);
        other.privateWaypoints.forEach(this::addWaypoint);
        this.dataSources.addAll(other.dataSources);
        this.fireInvalidate();
    }

    public synchronized Collection<GpxTrack> getTracks() {
        return Collections.unmodifiableCollection(this.privateTracks);
    }

    public synchronized void addTrack(GpxTrack track) {
        if (this.privateTracks.stream().anyMatch(t -> t == track)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was already added to this data: {0}", track));
        }
        this.privateTracks.add(track);
        track.addListener(this.proxy);
        this.fireInvalidate();
    }

    public synchronized void removeTrack(GpxTrack track) {
        if (!this.privateTracks.removeIf(t -> t == track)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was not in this data: {0}", track));
        }
        track.removeListener(this.proxy);
        this.fireInvalidate();
    }

    public synchronized Collection<GpxRoute> getRoutes() {
        return Collections.unmodifiableCollection(this.privateRoutes);
    }

    public synchronized void addRoute(GpxRoute route) {
        if (this.privateRoutes.stream().anyMatch(r -> r == route)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was already added to this data: {0}", route));
        }
        this.privateRoutes.add(route);
        this.fireInvalidate();
    }

    public synchronized void removeRoute(GpxRoute route) {
        if (!this.privateRoutes.removeIf(r -> r == route)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was not in this data: {0}", route));
        }
        this.fireInvalidate();
    }

    public synchronized Collection<WayPoint> getWaypoints() {
        return Collections.unmodifiableCollection(this.privateWaypoints);
    }

    public synchronized void addWaypoint(WayPoint waypoint) {
        if (this.privateWaypoints.stream().anyMatch(w -> w == waypoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was already added to this data: {0}", waypoint));
        }
        this.privateWaypoints.add(waypoint);
        this.fireInvalidate();
    }

    public synchronized void removeWaypoint(WayPoint waypoint) {
        if (!this.privateWaypoints.removeIf(w -> w == waypoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was not in this data: {0}", waypoint));
        }
        this.fireInvalidate();
    }

    public synchronized boolean hasTrackPoints() {
        return this.getTrackPoints().findAny().isPresent();
    }

    public synchronized Stream<WayPoint> getTrackPoints() {
        return this.getTracks().stream().flatMap(trk -> trk.getSegments().stream()).flatMap(trkseg -> trkseg.getWayPoints().stream());
    }

    public synchronized boolean hasRoutePoints() {
        return this.privateRoutes.stream().anyMatch(rte -> !rte.routePoints.isEmpty());
    }

    public synchronized boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds getMetaBounds() {
        Object value = this.get("meta.bounds");
        if (value instanceof Bounds) {
            return (Bounds)value;
        }
        return null;
    }

    public synchronized Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint wpt : this.privateWaypoints) {
            if (bounds == null) {
                bounds = new Bounds(wpt.getCoor());
                continue;
            }
            bounds.extend(wpt.getCoor());
        }
        for (GpxRoute rte : this.privateRoutes) {
            for (WayPoint wpt : rte.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wpt.getCoor());
                    continue;
                }
                bounds.extend(wpt.getCoor());
            }
        }
        for (GpxTrack trk : this.privateTracks) {
            Bounds trkBounds = trk.getBounds();
            if (trkBounds == null) continue;
            if (bounds == null) {
                bounds = new Bounds(trkBounds);
                continue;
            }
            bounds.extend(trkBounds);
        }
        return bounds;
    }

    public synchronized double length() {
        return this.privateTracks.stream().mapToDouble(GpxTrack::length).sum();
    }

    public static Date[] getMinMaxTimeForTrack(GpxTrack trk) {
        Date[] dateArray;
        DoubleSummaryStatistics statistics = trk.getSegments().stream().flatMap(seg -> seg.getWayPoints().stream()).mapToDouble(pnt -> pnt.time).summaryStatistics();
        if (statistics.getCount() == 0L) {
            dateArray = null;
        } else {
            Date[] dateArray2 = new Date[2];
            dateArray2[0] = new Date((long)(statistics.getMin() * 1000.0));
            dateArray = dateArray2;
            dateArray2[1] = new Date((long)(statistics.getMax() * 1000.0));
        }
        return dateArray;
    }

    public synchronized Date[] getMinMaxTimeForAllTracks() {
        Date[] dateArray;
        double now = (double)System.currentTimeMillis() / 1000.0;
        DoubleSummaryStatistics statistics = this.tracks.stream().flatMap(trk -> trk.getSegments().stream()).flatMap(seg -> seg.getWayPoints().stream()).mapToDouble(pnt -> pnt.time).filter(t -> t > 0.0 && t <= now).summaryStatistics();
        if (statistics.getCount() == 0L) {
            dateArray = new Date[]{};
        } else {
            Date[] dateArray2 = new Date[2];
            dateArray2[0] = new Date((long)(statistics.getMin() * 1000.0));
            dateArray = dateArray2;
            dateArray2[1] = new Date((long)(statistics.getMax() * 1000.0));
        }
        return dateArray;
    }

    public synchronized WayPoint nearestPointOnTrack(EastNorth p, double tolerance) {
        double pnminsq = tolerance * tolerance;
        EastNorth bestEN = null;
        double bestTime = 0.0;
        double px = p.east();
        double py = p.north();
        double rx = 0.0;
        double ry = 0.0;
        for (GpxTrack track : this.privateTracks) {
            for (GpxTrackSegment seg : track.getSegments()) {
                EastNorth c;
                double prsq;
                double y;
                double x;
                WayPoint r = null;
                for (WayPoint wpSeg : seg.getWayPoints()) {
                    EastNorth en = wpSeg.getEastNorth(Main.getProjection());
                    if (r == null) {
                        r = wpSeg;
                        rx = en.east();
                        x = px - rx;
                        double pRsq = x * x + (y = py - (ry = en.north())) * y;
                        if (!(pRsq < pnminsq)) continue;
                        pnminsq = pRsq;
                        bestEN = en;
                        bestTime = r.time;
                        continue;
                    }
                    double sx = en.east();
                    double sy = en.north();
                    double a = sy - ry;
                    double b = rx - sx;
                    double c2 = -a * rx - b * ry;
                    double rssq = a * a + b * b;
                    if (rssq == 0.0) continue;
                    double pnsq = a * px + b * py + c2;
                    if ((pnsq = pnsq * pnsq / rssq) < pnminsq) {
                        x = px - rx;
                        y = py - ry;
                        double prsq2 = x * x + y * y;
                        x = px - sx;
                        y = py - sy;
                        double pssq = x * x + y * y;
                        if (prsq2 - pnsq <= rssq && pssq - pnsq <= rssq) {
                            double rnoverRS = Math.sqrt((prsq2 - pnsq) / rssq);
                            double nx = rx - rnoverRS * b;
                            double ny = ry + rnoverRS * a;
                            bestEN = new EastNorth(nx, ny);
                            bestTime = r.time + rnoverRS * (wpSeg.time - r.time);
                            pnminsq = pnsq;
                        }
                    }
                    r = wpSeg;
                    rx = sx;
                    ry = sy;
                }
                if (r == null || !((prsq = (x = px - (rx = (c = r.getEastNorth(Main.getProjection())).east())) * x + (y = py - (ry = c.north())) * y) < pnminsq)) continue;
                pnminsq = prsq;
                bestEN = c;
                bestTime = r.time;
            }
        }
        if (bestEN == null) {
            return null;
        }
        WayPoint best = new WayPoint(Main.getProjection().eastNorth2latlon(bestEN));
        best.time = bestTime;
        return best;
    }

    public Iterable<Collection<WayPoint>> getLinesIterable(boolean ... trackVisibility) {
        return () -> new LinesIterator(this, trackVisibility);
    }

    public synchronized void resetEastNorthCache() {
        this.privateWaypoints.forEach(WayPoint::invalidateEastNorthCache);
        this.getTrackPoints().forEach(WayPoint::invalidateEastNorthCache);
        for (GpxRoute route : this.getRoutes()) {
            if (route.routePoints == null) continue;
            for (WayPoint wp : route.routePoints) {
                wp.invalidateEastNorthCache();
            }
        }
    }

    @Override
    public Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSources == null ? 0 : this.dataSources.hashCode());
        result = 31 * result + (this.privateRoutes == null ? 0 : this.privateRoutes.hashCode());
        result = 31 * result + (this.privateTracks == null ? 0 : this.privateTracks.hashCode());
        result = 31 * result + (this.privateWaypoints == null ? 0 : this.privateWaypoints.hashCode());
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GpxData other = (GpxData)obj;
        if (this.dataSources == null ? other.dataSources != null : !this.dataSources.equals(other.dataSources)) {
            return false;
        }
        if (this.privateRoutes == null ? other.privateRoutes != null : !this.privateRoutes.equals(other.privateRoutes)) {
            return false;
        }
        if (this.privateTracks == null ? other.privateTracks != null : !this.privateTracks.equals(other.privateTracks)) {
            return false;
        }
        return !(this.privateWaypoints == null ? other.privateWaypoints != null : !this.privateWaypoints.equals(other.privateWaypoints));
    }

    public void addChangeListener(GpxDataChangeListener listener) {
        this.listeners.addListener(listener);
    }

    public void addWeakChangeListener(GpxDataChangeListener listener) {
        this.listeners.addWeakListener(listener);
    }

    public void removeChangeListener(GpxDataChangeListener listener) {
        this.listeners.removeListener(listener);
    }

    private void fireInvalidate() {
        if (this.listeners.hasListeners()) {
            GpxDataChangeEvent e = new GpxDataChangeEvent(this);
            this.listeners.fireEvent(l -> l.gpxDataChanged(e));
        }
    }

    public static class GpxDataChangeEvent {
        private final GpxData source;

        GpxDataChangeEvent(GpxData source) {
            this.source = source;
        }

        public GpxData getSource() {
            return this.source;
        }
    }

    @FunctionalInterface
    public static interface GpxDataChangeListener {
        public void gpxDataChanged(GpxDataChangeEvent var1);
    }

    public static class LinesIterator
    implements Iterator<Collection<WayPoint>> {
        private Iterator<GpxTrack> itTracks;
        private int idxTracks;
        private Iterator<GpxTrackSegment> itTrackSegments;
        private final Iterator<GpxRoute> itRoutes;
        private Collection<WayPoint> next;
        private final boolean[] trackVisibility;

        public LinesIterator(GpxData data, boolean ... trackVisibility) {
            this.itTracks = data.tracks.iterator();
            this.idxTracks = -1;
            this.itRoutes = data.routes.iterator();
            this.trackVisibility = trackVisibility;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Collection<WayPoint> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Collection<WayPoint> current = this.next;
            this.next = this.getNext();
            return current;
        }

        private Collection<WayPoint> getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return this.itTrackSegments.next().getWayPoints();
                }
                while (this.itTracks.hasNext()) {
                    GpxTrack nxtTrack = this.itTracks.next();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = nxtTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return this.itTrackSegments.next().getWayPoints();
                }
                this.itTracks = null;
            }
            if (this.itRoutes.hasNext()) {
                return this.itRoutes.next().routePoints;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

