/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMember
implements PrimitiveId {
    private final String role;
    private final OsmPrimitive member;

    public String getRole() {
        return this.role;
    }

    public boolean hasRole() {
        return !"".equals(this.role);
    }

    public boolean hasRole(String ... roles) {
        return Arrays.asList(roles).contains(this.role);
    }

    public boolean isRelation() {
        return this.member instanceof Relation;
    }

    public boolean isWay() {
        return this.member instanceof Way;
    }

    public OsmPrimitiveType getDisplayType() {
        return this.member.getDisplayType();
    }

    public boolean isNode() {
        return this.member instanceof Node;
    }

    public Relation getRelation() {
        return (Relation)this.member;
    }

    public Way getWay() {
        return (Way)this.member;
    }

    public Node getNode() {
        return (Node)this.member;
    }

    public OsmPrimitive getMember() {
        return this.member;
    }

    public RelationMember(String role, OsmPrimitive member) {
        CheckParameterUtil.ensureParameterNotNull(member, "member");
        this.role = Optional.ofNullable(role).orElse("");
        this.member = member;
    }

    public RelationMember(RelationMember other) {
        this(other.role, other.member);
    }

    public String toString() {
        return '\"' + this.role + "\"=" + this.member;
    }

    public boolean refersTo(OsmPrimitive primitive) {
        return this.member == primitive;
    }

    public int hashCode() {
        return Objects.hash(this.role, this.member);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMember that = (RelationMember)obj;
        return Objects.equals(this.role, that.role) && Objects.equals(this.member, that.member);
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.member.getType();
    }

    @Override
    public long getUniqueId() {
        return this.member.getUniqueId();
    }

    @Override
    public boolean isNew() {
        return this.member.isNew();
    }
}

