/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.openstreetmap.josm.CLIModule;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ProjectionCLI
implements CLIModule {
    public static final ProjectionCLI INSTANCE = new ProjectionCLI();
    private boolean argInverse = false;
    private boolean argSwitchInput = false;
    private boolean argSwitchOutput = false;

    @Override
    public String getActionKeyword() {
        return "project";
    }

    @Override
    public void processArguments(String[] argArray) {
        int c;
        Getopt.setI18nHandler(x$0 -> I18n.tr(x$0, new Object[0]));
        Getopt getopt = new Getopt("JOSM projection", argArray, "Irh", new LongOpt[]{new LongOpt("help", 0, null, 104)});
        block8: while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 104: {
                    ProjectionCLI.showHelp();
                    System.exit(0);
                }
                case 73: {
                    this.argInverse = true;
                    continue block8;
                }
                case 114: {
                    this.argSwitchInput = true;
                    continue block8;
                }
                case 115: {
                    this.argSwitchOutput = true;
                    continue block8;
                }
            }
        }
        ArrayList projParamFrom = new ArrayList();
        ArrayList<String> projParamTo = new ArrayList<String>();
        ArrayList<String> otherPositional = new ArrayList<String>();
        boolean toTokenSeen = false;
        for (int i = getopt.getOptind(); i < argArray.length; ++i) {
            String arg = argArray[i];
            if (arg.isEmpty()) {
                throw new IllegalArgumentException("non-empty argument expected");
            }
            if (arg.startsWith("+")) {
                if (arg.equals("+to")) {
                    toTokenSeen = true;
                    continue;
                }
                (toTokenSeen ? projParamTo : projParamFrom).add(arg);
                continue;
            }
            otherPositional.add(arg);
        }
        String fromStr = Utils.join(" ", projParamFrom);
        String toStr = Utils.join(" ", projParamTo);
        try {
            this.run(fromStr, toStr, otherPositional);
        }
        catch (IOException | IllegalArgumentException | ProjectionConfigurationException ex) {
            System.err.println(I18n.tr("Error: {0}", ex.getMessage()));
            System.exit(1);
        }
        System.exit(0);
    }

    public static void showHelp() {
        System.out.println(ProjectionCLI.getHelp());
    }

    private static String getHelp() {
        return I18n.tr("JOSM projection command line interface", new Object[0]) + "\n\n" + I18n.tr("Usage", new Object[0]) + ":\n\tjava -jar josm.jar project <options> <crs> +to <crs> [file]\n\n" + I18n.tr("Description", new Object[0]) + ":\n" + I18n.tr("Converts coordinates from one coordinate reference system to another.", new Object[0]) + "\n\n" + I18n.tr("Options", new Object[0]) + ":\n\t--help|-h         " + I18n.tr("Show this help", new Object[0]) + "\n\t-I                " + I18n.tr("Switch input and output crs", new Object[0]) + "\n\t-r                " + I18n.tr("Switch order of input coordinates (east/north, lon/lat)", new Object[0]) + "\n\t-s                " + I18n.tr("Switch order of output coordinates (east/north, lon/lat)", new Object[0]) + "\n\n" + I18n.tr("<crs>", new Object[0]) + ":\n" + I18n.tr("The format for input and output coordinate reference system is similar to that of the PROJ.4 software.", new Object[0]) + "\n\n" + I18n.tr("[file]", new Object[0]) + ":\n" + I18n.tr("Reads input data from one or more files listed as positional arguments. When no files are given, or the filename is \"-\", data is read from standard input.", new Object[0]) + "\n\n" + I18n.tr("Examples", new Object[0]) + ":\n    java -jar josm.jar project +init=epsg:4326 +to +init=epsg:3857 <<<\"11.232274 50.5685716\"\n       => 1250371.1334500168 6545331.055189664\n\n    java -jar josm.jar project +proj=lonlat +datum=WGS84 +to +proj=merc +a=6378137 +b=6378137 +nadgrids=@null <<EOF\n    11d13'56.19\"E 50d34'6.86\"N\n    118d39'30.42\"W 37d20'18.76\"N\n    EOF\n       => 1250371.1334500168 6545331.055189664\n          -1.3208998232319113E7 4486401.160664663\n";
    }

    private void run(String fromStr, String toStr, List<String> files) throws ProjectionConfigurationException, IOException {
        CustomProjection fromProj = this.createProjection(fromStr);
        CustomProjection toProj = this.createProjection(toStr);
        if (this.argInverse) {
            CustomProjection tmp = fromProj;
            fromProj = toProj;
            toProj = tmp;
        }
        if (files.isEmpty() || files.get(0).equals("-")) {
            this.processInput(fromProj, toProj, new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())));
        } else {
            for (String file : files) {
                BufferedReader br = Files.newBufferedReader(Paths.get(file, new String[0]), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    this.processInput(fromProj, toProj, br);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
        }
    }

    private void processInput(CustomProjection fromProj, CustomProjection toProj, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            EastNorth enIn = fromProj.isGeographic() ? this.parseEastNorth(line, LatLonParser::parseCoordinate) : this.parseEastNorth(line, ProjectionCLI::parseDouble);
            LatLon ll = fromProj.eastNorth2latlon(enIn);
            EastNorth enOut = toProj.latlon2eastNorth(ll);
            double cOut1 = this.argSwitchOutput ? enOut.north() : enOut.east();
            double cOut2 = this.argSwitchOutput ? enOut.east() : enOut.north();
            System.out.println(Double.toString(cOut1) + " " + Double.toString(cOut2));
            System.out.flush();
        }
    }

    private CustomProjection createProjection(String params) throws ProjectionConfigurationException {
        CustomProjection proj = new CustomProjection();
        proj.update(params);
        return proj;
    }

    private EastNorth parseEastNorth(String s, Function<String, Double> parser) {
        String[] en = s.split("[;, ]+");
        if (en.length != 2) {
            throw new IllegalArgumentException(I18n.tr("Expected two coordinates, separated by white space, found {0} in ''{1}''", en.length, s));
        }
        double east = parser.apply(en[0]);
        double north = parser.apply(en[1]);
        if (this.argSwitchInput) {
            return new EastNorth(north, east);
        }
        return new EastNorth(east, north);
    }

    private static double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(I18n.tr("Unable to parse number ''{0}''", s));
        }
    }

    public static void main(String[] args) {
        INSTANCE.processArguments(args);
    }
}

