/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class TransverseMercator
extends AbstractProj {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private static final double EPSILON = 1.0E-6;
    private double eb2;
    protected double latitudeOfOrigin;
    private double ml0;
    protected double rectifiedGridAngle;
    private double sinrot;
    private double cosrot;

    @Override
    public String getName() {
        return I18n.tr("Transverse Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "tmerc";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        CheckParameterUtil.ensureParameterNotNull(params, "params");
        CheckParameterUtil.ensureParameterNotNull(params.ellps, "params.ellps");
        this.eb2 = params.ellps.eb2;
        this.latitudeOfOrigin = params.lat0 == null ? 0.0 : Utils.toRadians(params.lat0);
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
        this.rectifiedGridAngle = params.gamma != null ? Utils.toRadians(params.gamma) : 0.0;
        this.sinrot = Math.sin(this.rectifiedGridAngle);
        this.cosrot = Math.cos(this.rectifiedGridAngle);
    }

    @Override
    public double[] project(double y, double x) {
        double sinphi = Math.sin(y);
        double cosphi = Math.cos(y);
        double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
        t *= t;
        double al = cosphi * x;
        double als = al * al;
        double n = this.eb2 * cosphi * cosphi;
        y = this.mlfn(y, sinphi, cosphi) - this.ml0 + sinphi * (al /= Math.sqrt(1.0 - this.e2 * sinphi * sinphi)) * x * 0.5 * (1.0 + 0.08333333333333333 * als * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * (1385.0 + t * (t * (543.0 - t) - 3111.0)))));
        x = al * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * (61.0 + t * (t * (179.0 - t) - 479.0)))));
        double u = y;
        double v = x;
        x = v * this.cosrot + u * this.sinrot;
        y = u * this.cosrot - v * this.sinrot;
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double v = x * this.cosrot - y * this.sinrot;
        double u = y * this.cosrot + x * this.sinrot;
        x = v;
        y = u;
        double phi = this.invMlfn(this.ml0 + y);
        if (Math.abs(phi) >= 1.5707963267948966) {
            y = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            x = 0.0;
        } else {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double t = Math.abs(cosphi) > 1.0E-6 ? sinphi / cosphi : 0.0;
            double n = this.eb2 * cosphi * cosphi;
            double con = 1.0 - this.e2 * sinphi * sinphi;
            double d = x * Math.sqrt(con);
            con *= t;
            t *= t;
            double ds = d * d;
            y = phi - con * ds / (1.0 - this.e2) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t))))));
            x = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t)))))) / cosphi;
        }
        return new double[]{y, x};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -7.0, 89.0, 7.0, false);
    }

    public static Pair<Integer, Hemisphere> locateUtmZone(LatLon ll) {
        return new Pair<Integer, Hemisphere>((int)Math.floor((ll.lon() + 180.0) / 6.0) + 1, ll.lat() > 0.0 ? Hemisphere.North : Hemisphere.South);
    }

    public static enum Hemisphere {
        North,
        South;

    }
}

