/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.EnumProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.IExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.properties.RecentTagCollection;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class TagEditHelper {
    private final JTable tagTable;
    private final DefaultTableModel tagData;
    private final Map<String, Map<String, Integer>> valueCount;
    protected Collection<OsmPrimitive> sel;
    private String changedKey;
    private String objKey;
    static final Comparator<AutoCompletionItem> DEFAULT_AC_ITEM_COMPARATOR = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);
    public static final ListProperty PROPERTY_RECENT_TAGS = new ListProperty("properties.recent-tags", Collections.emptyList());
    public static final StringProperty PROPERTY_TAGS_TO_IGNORE = new StringProperty("properties.recent-tags.ignore", new SearchSetting().writeToString());
    public static final EnumProperty<RecentExisting> PROPERTY_RECENT_EXISTING = new EnumProperty<RecentExisting>("properties.recently-added-tags-existing-key", RecentExisting.class, RecentExisting.DISABLE);
    public static final EnumProperty<RefreshRecent> PROPERTY_REFRESH_RECENT = new EnumProperty<RefreshRecent>("properties.refresh-recently-added-tags", RefreshRecent.class, RefreshRecent.STATUS);
    final RecentTagCollection recentTags = new RecentTagCollection(30);
    SearchSetting tagsToIgnore;
    private List<Tag> tags;

    public TagEditHelper(JTable tagTable, DefaultTableModel propertyData, Map<String, Map<String, Integer>> valueCount) {
        this.tagTable = tagTable;
        this.tagData = propertyData;
        this.valueCount = valueCount;
    }

    public final String getDataKey(int viewRow) {
        return this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(viewRow), 0).toString();
    }

    boolean containsDataKey(String key) {
        return IntStream.range(0, this.tagData.getRowCount()).anyMatch(i -> key.equals(this.tagData.getValueAt(i, 0)) && !((Map)this.tagData.getValueAt(i, 1)).containsKey(""));
    }

    public final Map<String, Integer> getDataValues(int viewRow) {
        return (Map)this.tagData.getValueAt(this.tagTable.convertRowIndexToModel(viewRow), 1);
    }

    public void addTag() {
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        AddTagsDialog addDialog = this.getAddTagsDialog();
        addDialog.showDialog();
        addDialog.destroyActions();
        if (addDialog.getValue() == 1) {
            addDialog.performTagAdding();
        } else {
            addDialog.undoAllTagsAdding();
        }
    }

    protected AddTagsDialog getAddTagsDialog() {
        return new AddTagsDialog();
    }

    public void editTag(int row, boolean focusOnKey) {
        String key;
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        this.objKey = key = this.getDataKey(row);
        IEditTagDialog editDialog = this.getEditTagDialog(row, focusOnKey, key);
        editDialog.showDialog();
        if (editDialog.getValue() != 1) {
            return;
        }
        editDialog.performTagEdit();
    }

    protected IEditTagDialog getEditTagDialog(int row, boolean focusOnKey, String key) {
        return new EditTagDialog(key, this.getDataValues(row), focusOnKey);
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    public void resetChangedKey() {
        this.changedKey = null;
    }

    private static List<String> getAutocompletionKeys(String key) {
        if ("name".equals(key) || "addr:street".equals(key)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(key);
    }

    public void loadTagsIfNeeded() {
        this.loadTagsToIgnore();
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && this.recentTags.isEmpty()) {
            this.recentTags.loadFromPreference(PROPERTY_RECENT_TAGS);
        }
    }

    void loadTagsToIgnore() {
        SearchSetting searchSetting = Utils.firstNonNull(SearchSetting.readFromString(PROPERTY_TAGS_TO_IGNORE.get()), new SearchSetting());
        if (!Objects.equals(this.tagsToIgnore, searchSetting)) {
            try {
                this.tagsToIgnore = searchSetting;
                this.recentTags.setTagsToIgnore(this.tagsToIgnore);
            }
            catch (SearchParseError parseError) {
                TagEditHelper.warnAboutParseError(parseError);
                this.tagsToIgnore = new SearchSetting();
                this.recentTags.setTagsToIgnore(SearchCompiler.Never.INSTANCE);
            }
        }
    }

    private static void warnAboutParseError(SearchParseError parseError) {
        Logging.warn(parseError);
        JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
    }

    public void saveTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && !this.recentTags.isEmpty()) {
            this.recentTags.saveToPreference(PROPERTY_RECENT_TAGS);
        }
    }

    private void cacheRecentTags() {
        this.tags = this.recentTags.toList();
        Collections.reverse(this.tags);
    }

    private static boolean warnOverwriteKey(String action, String togglePref) {
        return new ExtendedDialog(Main.parent, I18n.tr("Overwrite key", new Object[0]), I18n.tr("Replace", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("purge", "cancel").setContent(action + '\n' + I18n.tr("The new key is already used, overwrite values?", new Object[0])).setCancelButton(2).toggleEnable(togglePref).showDialog().getValue() == 1;
    }

    static {
        RecentTagCollection recentTags = new RecentTagCollection(30);
        recentTags.loadFromPreference(PROPERTY_RECENT_TAGS);
        recentTags.toList().forEach(tag -> AutoCompletionManager.rememberUserInput(tag.getKey(), tag.getValue(), false));
    }

    protected class AddTagsDialog
    extends AbstractTagsDialog {
        private final List<JosmAction> recentTagsActions;
        protected final transient FocusAdapter focus;
        private final JPanel mainPanel;
        private JPanel recentTagsPanel;
        private int commandCount;

        protected AddTagsDialog() {
            super(Main.parent, I18n.tr("Add value?", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.setButtonIcons("ok", "cancel");
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            this.mainPanel = new JPanel(new GridBagLayout());
            this.keys = new AutoCompletingComboBox();
            this.values = new AutoCompletingComboBox();
            this.mainPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
            TagEditHelper.this.cacheRecentTags();
            AutoCompletionManager autocomplete = AutoCompletionManager.of(Main.main.getEditDataSet());
            List<AutoCompletionItem> keyList = autocomplete.getTagKeys(DEFAULT_AC_ITEM_COMPARATOR);
            keyList.removeIf(item -> TagEditHelper.this.containsDataKey(item.getValue()));
            this.keys.setPossibleAcItems(keyList);
            this.keys.setEditable(true);
            this.mainPanel.add((Component)this.keys, GBC.eop().fill(2));
            this.mainPanel.add((Component)new JLabel(I18n.tr("Please select a value", new Object[0])), GBC.eol());
            this.values.setEditable(true);
            this.mainPanel.add((Component)this.values, GBC.eop().fill(2));
            TagEditHelper.this.tags.stream().filter(tag -> !TagEditHelper.this.containsDataKey(tag.getKey())).findFirst().ifPresent(tag -> {
                this.keys.setSelectedItem(tag.getKey());
                this.values.setSelectedItem(tag.getValue());
            });
            this.focus = this.addFocusAdapter(autocomplete, DEFAULT_AC_ITEM_COMPARATOR);
            this.focus.focusGained(null);
            this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 64), "addAndContinue");
            this.mainPanel.getActionMap().put("addAndContinue", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.performTagAdding();
                    AddTagsDialog.this.refreshRecentTags();
                    AddTagsDialog.this.selectKeysComboBox();
                }
            });
            this.suggestRecentlyAddedTags();
            this.mainPanel.add(Box.createVerticalGlue(), GBC.eop().fill());
            this.setContent(this.mainPanel, false);
            this.selectKeysComboBox();
            this.popupMenu.add(new AbstractAction(I18n.tr("Set number of recently added tags", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.selectNumberOfTags();
                    AddTagsDialog.this.suggestRecentlyAddedTags();
                }
            });
            this.popupMenu.add(this.buildMenuRecentExisting());
            this.popupMenu.add(this.buildMenuRefreshRecent());
            JCheckBoxMenuItem rememberLastTags = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Remember last used tags after a restart", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean state = ((JCheckBoxMenuItem)e.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(state);
                    if (state) {
                        TagEditHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            rememberLastTags.setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add(rememberLastTags);
        }

        private JMenu buildMenuRecentExisting() {
            JMenu menu = new JMenu(I18n.tr("Recent tags with existing key", new Object[0]));
            TreeMap<RecentExisting, String> radios = new TreeMap<RecentExisting, String>();
            radios.put(RecentExisting.ENABLE, I18n.tr("Enable", new Object[0]));
            radios.put(RecentExisting.DISABLE, I18n.tr("Disable", new Object[0]));
            radios.put(RecentExisting.HIDE, I18n.tr("Hide", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : radios.entrySet()) {
                JRadioButtonMenuItem radio = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PROPERTY_RECENT_EXISTING.put((RecentExisting)((Object)entry.getKey()), new String[0]);
                        AddTagsDialog.this.suggestRecentlyAddedTags();
                    }
                });
                buttonGroup.add(radio);
                radio.setSelected(PROPERTY_RECENT_EXISTING.get(new String[0]) == entry.getKey());
                menu.add(radio);
            }
            return menu;
        }

        private JMenu buildMenuRefreshRecent() {
            JMenu menu = new JMenu(I18n.tr("Refresh recent tags list after applying tag", new Object[0]));
            TreeMap<RefreshRecent, String> radios = new TreeMap<RefreshRecent, String>();
            radios.put(RefreshRecent.NO, I18n.tr("No refresh", new Object[0]));
            radios.put(RefreshRecent.STATUS, I18n.tr("Refresh tag status only (enabled / disabled)", new Object[0]));
            radios.put(RefreshRecent.REFRESH, I18n.tr("Refresh tag status and list of recently added tags", new Object[0]));
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final Map.Entry entry : radios.entrySet()) {
                JRadioButtonMenuItem radio = new JRadioButtonMenuItem(new AbstractAction((String)entry.getValue()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PROPERTY_REFRESH_RECENT.put((RefreshRecent)((Object)entry.getKey()), new String[0]);
                    }
                });
                buttonGroup.add(radio);
                radio.setSelected(PROPERTY_REFRESH_RECENT.get(new String[0]) == entry.getKey());
                menu.add(radio);
            }
            return menu;
        }

        @Override
        public void setContentPane(Container contentPane) {
            int commandDownMask = Main.platform.getMenuShortcutKeyMaskEx();
            ArrayList<String> lines = new ArrayList<String>();
            Shortcut.findShortcut(49, commandDownMask).ifPresent(sc -> lines.add(sc.getKeyText() + ' ' + I18n.tr("to apply first suggestion", new Object[0])));
            lines.add(Shortcut.getKeyText(KeyStroke.getKeyStroke(10, 64)) + ' ' + I18n.tr("to add without closing the dialog", new Object[0]));
            Shortcut.findShortcut(49, commandDownMask | 0x40).ifPresent(sc -> lines.add(sc.getKeyText() + ' ' + I18n.tr("to add first suggestion without closing the dialog", new Object[0])));
            JLabel helpLabel = new JLabel("<html>" + Utils.join("<br>", lines) + "</html>");
            helpLabel.setFont(helpLabel.getFont().deriveFont(0));
            contentPane.add((Component)helpLabel, GBC.eol().fill(2).insets(5, 5, 5, 5));
            super.setContentPane(contentPane);
        }

        protected void selectNumberOfTags() {
            String s = String.format("%d", PROPERTY_RECENT_TAGS_NUMBER.get());
            while ((s = JOptionPane.showInputDialog(this, I18n.tr("Please enter the number of recently added tags to display", new Object[0]), s)) != null && !s.isEmpty()) {
                try {
                    int v = Integer.parseInt(s);
                    if (v >= 0 && v <= 30) {
                        PROPERTY_RECENT_TAGS_NUMBER.put(v);
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    Logging.warn(ex);
                }
                JOptionPane.showMessageDialog(this, I18n.tr("Please enter integer number between 0 and {0}", 30));
            }
            return;
        }

        protected void suggestRecentlyAddedTags() {
            if (this.recentTagsPanel == null) {
                this.recentTagsPanel = new JPanel(new GridBagLayout());
                this.buildRecentTagsPanel();
                this.mainPanel.add((Component)this.recentTagsPanel, GBC.eol().fill(2));
            } else {
                Dimension panelOldSize = this.recentTagsPanel.getPreferredSize();
                this.recentTagsPanel.removeAll();
                this.buildRecentTagsPanel();
                Dimension panelNewSize = this.recentTagsPanel.getPreferredSize();
                Dimension dialogOldSize = this.getMinimumSize();
                Dimension dialogNewSize = new Dimension(dialogOldSize.width, dialogOldSize.height - panelOldSize.height + panelNewSize.height);
                this.setMinimumSize(dialogNewSize);
                this.setPreferredSize(dialogNewSize);
                this.setSize(dialogNewSize);
                this.revalidate();
                this.repaint();
            }
        }

        protected void buildRecentTagsPanel() {
            int tagsToShow = Math.min(PROPERTY_RECENT_TAGS_NUMBER.get(), 30);
            if (tagsToShow <= 0 || TagEditHelper.this.recentTags.isEmpty()) {
                return;
            }
            this.recentTagsPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int count = 0;
            this.destroyActions();
            for (int i = 0; i < TagEditHelper.this.tags.size() && count < tagsToShow; ++i) {
                ImageIcon icon;
                final Tag t = (Tag)TagEditHelper.this.tags.get(i);
                boolean keyExists = TagEditHelper.this.containsDataKey(t.getKey());
                if (keyExists && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.HIDE) continue;
                Shortcut sc = ++count > 10 ? null : Shortcut.registerShortcut("properties:recent:" + count, I18n.tr("Choose recent tag {0}", count), 48 + count % 10, 5006);
                final JosmAction action = new JosmAction(I18n.tr("Choose recent tag {0}", count), null, I18n.tr("Use this tag again", new Object[0]), sc, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddTagsDialog.this.keys.setSelectedItem(t.getKey());
                        AddTagsDialog.this.focus.focusGained(null);
                        AddTagsDialog.this.values.setSelectedItem(t.getValue());
                        AddTagsDialog.this.selectValuesCombobox();
                    }
                };
                Shortcut scShift = count > 10 ? null : Shortcut.registerShortcut("properties:recent:apply:" + count, I18n.tr("Apply recent tag {0}", count), 48 + count % 10, 5009);
                JosmAction actionShift = new JosmAction(I18n.tr("Apply recent tag {0}", count), null, I18n.tr("Use this tag again", new Object[0]), scShift, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        action.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                        AddTagsDialog.this.refreshRecentTags();
                        AddTagsDialog.this.selectKeysComboBox();
                    }
                };
                this.recentTagsActions.add(action);
                this.recentTagsActions.add(actionShift);
                if (keyExists && PROPERTY_RECENT_EXISTING.get(new String[0]) == RecentExisting.DISABLE) {
                    action.setEnabled(false);
                }
                if ((icon = MapPaintStyles.getNodeIcon(t, false)) == null) {
                    TaggingPreset tp;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(t.getKey(), t.getValue());
                    Iterator<TaggingPreset> iterator = TaggingPresets.getMatchingPresets(null, map, false).iterator();
                    while (iterator.hasNext() && (icon = (tp = iterator.next()).getIcon()) == null) {
                    }
                    if (icon == null) {
                        icon = new ImageIcon(new BufferedImage(16, 16, 2));
                    }
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.ipadx = 5;
                this.recentTagsPanel.add((Component)new JLabel(action.isEnabled() ? icon : GuiHelper.getDisabledIcon(icon)), gbc);
                String color = action.isEnabled() ? "" : "; color:gray";
                JLabel tagLabel = new JLabel("<html><style>td{" + color + "}</style><table><tr><td>" + count + ".</td><td style='border:1px solid gray'>" + XmlWriter.encode(t.toString(), true) + '<' + "/td></tr></table></html>");
                tagLabel.setFont(tagLabel.getFont().deriveFont(0));
                if (action.isEnabled() && sc != null && scShift != null) {
                    this.recentTagsPanel.getInputMap(2).put(sc.getKeyStroke(), "choose" + count);
                    this.recentTagsPanel.getActionMap().put("choose" + count, action);
                    this.recentTagsPanel.getInputMap(2).put(scShift.getKeyStroke(), "apply" + count);
                    this.recentTagsPanel.getActionMap().put("apply" + count, actionShift);
                }
                if (action.isEnabled()) {
                    tagLabel.setToolTipText((String)action.getValue("ShortDescription"));
                    tagLabel.setCursor(Cursor.getPredefinedCursor(12));
                    tagLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            action.actionPerformed(null);
                            if (SwingUtilities.isRightMouseButton(e)) {
                                new TagPopupMenu(t).show(e.getComponent(), e.getX(), e.getY());
                            } else if (e.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                                AddTagsDialog.this.refreshRecentTags();
                                AddTagsDialog.this.selectKeysComboBox();
                            } else if (e.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                        }
                    });
                } else {
                    tagLabel.setEnabled(false);
                    tagLabel.setToolTipText(I18n.tr("The key ''{0}'' is already used", t.getKey()));
                }
                JPanel tagPanel = new JPanel(new FlowLayout(0, 0, 0));
                tagPanel.add(tagLabel);
                this.recentTagsPanel.add((Component)tagPanel, GBC.eol().fill(2));
            }
            if (count == 0) {
                this.recentTagsPanel.removeAll();
            }
        }

        public void destroyActions() {
            for (JosmAction action : this.recentTagsActions) {
                action.destroy();
            }
            this.recentTagsActions.clear();
        }

        public final void performTagAdding() {
            String key = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            String value = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if (key.isEmpty() || value.isEmpty()) {
                return;
            }
            for (OsmPrimitive osm : TagEditHelper.this.sel) {
                String val = osm.get(key);
                if (val == null || val.equals(value)) continue;
                if (TagEditHelper.warnOverwriteKey(I18n.tr("You changed the value of ''{0}'' from ''{1}'' to ''{2}''.", key, val, value), "overwriteAddKey")) break;
                return;
            }
            TagEditHelper.this.recentTags.add(new Tag(key, value));
            TagEditHelper.this.valueCount.put(key, new TreeMap());
            AutoCompletionManager.rememberUserInput(key, value, false);
            ++this.commandCount;
            MainApplication.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, key, value));
            TagEditHelper.this.changedKey = key;
            this.clearEntries();
        }

        protected void clearEntries() {
            this.keys.getEditor().setItem("");
            this.values.getEditor().setItem("");
        }

        public void undoAllTagsAdding() {
            MainApplication.undoRedo.undo(this.commandCount);
        }

        private void refreshRecentTags() {
            switch ((RefreshRecent)((Object)PROPERTY_REFRESH_RECENT.get(new String[0]))) {
                case REFRESH: {
                    TagEditHelper.this.cacheRecentTags();
                    this.suggestRecentlyAddedTags();
                    break;
                }
                case STATUS: {
                    this.suggestRecentlyAddedTags();
                    break;
                }
            }
        }

        class EditIgnoreTagsAction
        extends AbstractAction {
            EditIgnoreTagsAction() {
                super(I18n.tr("Edit ignore list", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSetting newTagsToIngore = SearchAction.showSearchDialog(TagEditHelper.this.tagsToIgnore);
                if (newTagsToIngore == null) {
                    return;
                }
                try {
                    TagEditHelper.this.tagsToIgnore = newTagsToIngore;
                    TagEditHelper.this.recentTags.setTagsToIgnore(TagEditHelper.this.tagsToIgnore);
                    PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                }
                catch (SearchParseError parseError) {
                    TagEditHelper.warnAboutParseError(parseError);
                }
            }
        }

        class IgnoreTagAction
        extends AbstractAction {
            final transient Tag tag;

            IgnoreTagAction(String name, Tag tag) {
                super(name);
                this.tag = tag;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (TagEditHelper.this.tagsToIgnore != null) {
                        TagEditHelper.this.recentTags.ignoreTag(this.tag, TagEditHelper.this.tagsToIgnore);
                        PROPERTY_TAGS_TO_IGNORE.put(TagEditHelper.this.tagsToIgnore.writeToString());
                    }
                }
                catch (SearchParseError parseError) {
                    throw new IllegalStateException(parseError);
                }
            }
        }

        class TagPopupMenu
        extends JPopupMenu {
            TagPopupMenu(Tag t) {
                this.add(new IgnoreTagAction(I18n.tr("Ignore key ''{0}''", t.getKey()), new Tag(t.getKey(), "")));
                this.add(new IgnoreTagAction(I18n.tr("Ignore tag ''{0}''", t), t));
                this.add(new EditIgnoreTagsAction());
            }
        }
    }

    protected abstract class AbstractTagsDialog
    extends ExtendedDialog {
        protected AutoCompletingComboBox keys;
        protected AutoCompletingComboBox values;
        protected JPopupMenu popupMenu;

        AbstractTagsDialog(Component parent, String title, String ... buttonTexts) {
            super(parent, title, buttonTexts);
            this.popupMenu = new JPopupMenu(){
                private final JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Use English language for tag by default", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean use = ((JCheckBoxMenuItem)e.getSource()).getState();
                        PROPERTY_FIX_TAG_LOCALE.put(use);
                        AbstractTagsDialog.this.keys.setFixedLocale(use);
                    }
                });
                {
                    this.add(this.fixTagLanguageCb);
                    this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
                }
            };
            this.addMouseListener(new PopupMenuLauncher(this.popupMenu));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            Dimension size = this.getSize();
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, size));
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                Dimension size;
                WindowGeometry geometry = this.initWindowGeometry();
                Dimension storedSize = geometry.getSize();
                if (!storedSize.equals(size = this.getSize())) {
                    if (storedSize.width < size.width) {
                        storedSize.width = size.width;
                    }
                    if (storedSize.height != size.height) {
                        storedSize.height = size.height;
                    }
                    this.rememberWindowGeometry(geometry);
                }
                this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get());
            }
            super.setVisible(visible);
        }

        private void selectACComboBoxSavingUnixBuffer(AutoCompletingComboBox cb) {
            Clipboard sysSel = ClipboardUtils.getSystemSelection();
            if (sysSel != null) {
                Transferable old = ClipboardUtils.getClipboardContent(sysSel);
                cb.requestFocusInWindow();
                cb.getEditor().selectAll();
                if (old != null) {
                    sysSel.setContents(old, null);
                }
            } else {
                cb.requestFocusInWindow();
                cb.getEditor().selectAll();
            }
        }

        public void selectKeysComboBox() {
            this.selectACComboBoxSavingUnixBuffer(this.keys);
        }

        public void selectValuesCombobox() {
            this.selectACComboBoxSavingUnixBuffer(this.values);
        }

        protected FocusAdapter addFocusAdapter(final AutoCompletionManager autocomplete, final Comparator<AutoCompletionItem> comparator) {
            JTextField editor = this.values.getEditorComponent();
            FocusAdapter focus = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    Logging.trace("Focus gained by {0}, e={1}", AbstractTagsDialog.this.values, e);
                    String key = AbstractTagsDialog.this.keys.getEditor().getItem().toString();
                    if (!Objects.equals(key, TagEditHelper.this.objKey)) {
                        AbstractTagsDialog.this.values.setPossibleAcItems(autocomplete.getTagValues(TagEditHelper.getAutocompletionKeys(key), (Comparator<AutoCompletionItem>)comparator));
                        AbstractTagsDialog.this.values.getEditor().selectAll();
                        TagEditHelper.this.objKey = key;
                    }
                }
            };
            editor.addFocusListener(focus);
            return focus;
        }
    }

    protected class EditTagDialog
    extends AbstractTagsDialog
    implements IEditTagDialog {
        private final String key;
        private final transient Map<String, Integer> m;
        private final transient Comparator<AutoCompletionItem> usedValuesAwareComparator;
        private final transient ListCellRenderer<AutoCompletionItem> cellRenderer;

        protected EditTagDialog(String key, Map<String, Integer> map, final boolean initialFocusOnKey) {
            super(Main.parent, I18n.trn("Change value?", "Change values?", map.size(), new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.cellRenderer = new ListCellRenderer<AutoCompletionItem>(){
                private final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends AutoCompletionItem> list, AutoCompletionItem value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = this.def.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (c instanceof JLabel) {
                        Map map;
                        String str = value.getValue();
                        if (TagEditHelper.this.valueCount.containsKey(TagEditHelper.this.objKey) && (map = (Map)TagEditHelper.this.valueCount.get(TagEditHelper.this.objKey)).containsKey(str)) {
                            str = I18n.tr("{0} ({1})", str, map.get(str));
                            c.setFont(c.getFont().deriveFont(3));
                        }
                        ((JLabel)c).setText(str);
                    }
                    return c;
                }
            };
            this.setButtonIcons("ok", "cancel");
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/EditValue", true);
            this.key = key;
            this.m = map;
            this.usedValuesAwareComparator = (o1, o2) -> {
                boolean c2;
                boolean c1 = this.m.containsKey(o1.getValue());
                if (c1 == (c2 = this.m.containsKey(o2.getValue()))) {
                    return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
                }
                if (c1) {
                    return -1;
                }
                return 1;
            };
            JPanel mainPanel = new JPanel(new BorderLayout());
            String msg = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", key) + ")</html>";
            mainPanel.add((Component)new JLabel(msg), "North");
            JPanel p = new JPanel(new GridBagLayout());
            mainPanel.add((Component)p, "Center");
            AutoCompletionManager autocomplete = AutoCompletionManager.of(MainApplication.getLayerManager().getEditLayer().data);
            List<AutoCompletionItem> keyList = autocomplete.getTagKeys(DEFAULT_AC_ITEM_COMPARATOR);
            this.keys = new AutoCompletingComboBox(key);
            this.keys.setPossibleAcItems(keyList);
            this.keys.setEditable(true);
            this.keys.setSelectedItem(key);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.keys, GBC.eol().fill(2));
            List<AutoCompletionItem> valueList = autocomplete.getTagValues(TagEditHelper.getAutocompletionKeys(key), this.usedValuesAwareComparator);
            String selection = this.m.size() != 1 ? I18n.tr("<different>", new Object[0]) : this.m.entrySet().iterator().next().getKey();
            this.values = new AutoCompletingComboBox(selection);
            this.values.setRenderer(this.cellRenderer);
            this.values.setEditable(true);
            this.values.setPossibleAcItems(valueList);
            this.values.setSelectedItem(selection);
            this.values.getEditor().setItem(selection);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.values, GBC.eol().fill(2));
            this.values.getEditor().addActionListener(e -> this.buttonAction(0, null));
            this.addFocusAdapter(autocomplete, this.usedValuesAwareComparator);
            this.setContent(mainPanel, false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (initialFocusOnKey) {
                        EditTagDialog.this.selectKeysComboBox();
                    } else {
                        EditTagDialog.this.selectValuesCombobox();
                    }
                }
            });
        }

        @Override
        public void performTagEdit() {
            String value = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if ((value = Normalizer.normalize(value, Normalizer.Form.NFC)).isEmpty()) {
                value = null;
            }
            String newkey = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            if ((newkey = Normalizer.normalize(newkey, Normalizer.Form.NFC)).isEmpty()) {
                newkey = this.key;
                value = null;
            }
            if (this.key.equals(newkey) && I18n.tr("<different>", new Object[0]).equals(value)) {
                return;
            }
            if (this.key.equals(newkey) || value == null) {
                MainApplication.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                AutoCompletionManager.rememberUserInput(newkey, value, true);
            } else {
                for (OsmPrimitive osm : TagEditHelper.this.sel) {
                    if (osm.get(newkey) == null) continue;
                    if (TagEditHelper.warnOverwriteKey(I18n.tr("You changed the key from ''{0}'' to ''{1}''.", this.key, newkey), "overwriteEditKey")) break;
                    return;
                }
                ArrayList<Command> commands = new ArrayList<Command>();
                commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, this.key, null));
                if (value.equals(I18n.tr("<different>", new Object[0]))) {
                    HashMap map = new HashMap();
                    for (OsmPrimitive osmPrimitive : TagEditHelper.this.sel) {
                        String val = osmPrimitive.get(this.key);
                        if (val == null) continue;
                        if (map.containsKey(val)) {
                            ((List)map.get(val)).add(osmPrimitive);
                            continue;
                        }
                        ArrayList<OsmPrimitive> v = new ArrayList<OsmPrimitive>();
                        v.add(osmPrimitive);
                        map.put(val, v);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        commands.add(new ChangePropertyCommand((Collection)entry.getValue(), newkey, (String)entry.getKey()));
                    }
                } else {
                    commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                    AutoCompletionManager.rememberUserInput(newkey, value, false);
                }
                MainApplication.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()), commands));
            }
            TagEditHelper.this.changedKey = newkey;
        }
    }

    protected static interface IEditTagDialog
    extends IExtendedDialog {
        public void performTagEdit();
    }

    private static enum RefreshRecent {
        NO,
        STATUS,
        REFRESH;

    }

    private static enum RecentExisting {
        ENABLE,
        DISABLE,
        HIDE;

    }
}

