/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SavingAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RefreshAction
extends SavingAction
implements UndoRedoHandler.CommandQueueListener {
    public RefreshAction(MemberTable memberTable, MemberTableModel memberTableModel, TagEditorModel tagModel, OsmDataLayer layer, IRelationEditor editor) {
        super(memberTable, memberTableModel, tagModel, layer, editor, null);
        Shortcut sc = Shortcut.registerShortcut("relationeditor:refresh", I18n.tr("Relation Editor: Refresh", new Object[0]), 65535, 5000);
        this.putValue("ShortDescription", Main.platform.makeTooltip(I18n.tr("Refresh relation from data layer", new Object[0]), sc));
        new ImageProvider("dialogs/refresh").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Refresh", new Object[0]));
        if (editor instanceof JComponent) {
            ((JComponent)((Object)editor)).getRootPane().getActionMap().put("refresh", this);
            ((JComponent)((Object)editor)).getRootPane().getInputMap(2).put(sc.getKeyStroke(), "refresh");
        }
        MainApplication.undoRedo.addCommandQueueListener(this);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation relation = this.editor.getRelation();
        if (relation == null) {
            return;
        }
        if (relation.isDeleted()) {
            if (this.confirmCloseDeletedRelation() == 0) {
                this.hideEditor();
            }
            return;
        }
        if (this.isEditorDirty() && this.confirmDiscardDirtyData() != 0) {
            return;
        }
        this.editor.reloadDataFromRelation();
    }

    @Override
    public void updateEnabledState() {
        Relation relation = this.editor.getRelation();
        Relation snapshot = this.editor.getRelationSnapshot();
        this.setEnabled(snapshot != null && (!relation.hasEqualTechnicalAttributes(snapshot) || !relation.hasEqualSemanticAttributes(snapshot)));
    }

    protected int confirmDiscardDirtyData() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, discard changes and reload", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to discard the changes and reload data from layer", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        return HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You have unsaved changes in this editor window.<br><br>Do you want to discard these changes and reload data from layer?</html>", new Object[0]), I18n.tr("Unsaved changes", new Object[0]), 2, null, options, options[1], "/Dialog/RelationEditor#Reload");
    }

    protected int confirmCloseDeletedRelation() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to close window", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        return HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>Relation has been deleted outside editor.<br><br>Do you want to close this window?</html>", new Object[0]), I18n.tr("Deleted relation", new Object[0]), 2, null, options, options[0], "/Dialog/RelationEditor#Reload");
    }

    @Override
    public void commandChanged(int queueSize, int redoSize) {
        this.updateEnabledState();
    }
}

