/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;

public class ValidatorTreePanel
extends JTree
implements Destroyable,
DataSetListener {
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private transient List<TestError> errors = new ArrayList<TestError>();
    private transient Set<? extends OsmPrimitive> filter;
    private final ListenerList<Runnable> invalidationListeners = ListenerList.create();

    public ValidatorTreePanel(List<TestError> errors) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(errors);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!"javax.swing.plaf.basic.BasicTreeUI$Handler".equals(keyListener.getClass().getName())) continue;
            this.removeKeyListener(keyListener);
        }
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String res = null;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof TestError) {
                TestError error = (TestError)nodeInfo;
                MultipleNameVisitor v = new MultipleNameVisitor();
                v.visit(error.getPrimitives());
                res = "<html>" + v.getText() + "<br>" + error.getMessage();
                String d = error.getDescription();
                if (d != null) {
                    res = res + "<br>" + d;
                }
                res = res + "</html>";
            } else {
                res = node.toString();
            }
        }
        return res;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(v);
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    public void buildTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            GuiHelper.runInEDTAndWait(() -> this.valTreeModel.setRoot(rootNode));
            return;
        }
        Collections.sort(this.errors);
        HashSet<Object> oldSelectedRows = new HashSet<Object>();
        Enumeration<TreePath> expanded = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath path = expanded.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof Severity) {
                    oldSelectedRows.add(userObject);
                    continue;
                }
                if (!(userObject instanceof String)) continue;
                String msg = (String)userObject;
                int index = msg.lastIndexOf(" (");
                if (index > 0) {
                    msg = msg.substring(0, index);
                }
                oldSelectedRows.add(msg);
            }
        }
        Predicate<TestError> filterToUse = e -> !e.isIgnored();
        if (!ValidatorPrefHelper.PREF_OTHER.get().booleanValue()) {
            filterToUse = filterToUse.and(e -> e.getSeverity() != Severity.OTHER);
        }
        if (this.filter != null) {
            filterToUse = filterToUse.and(e -> e.getPrimitives().stream().anyMatch(this.filter::contains));
        }
        Map<Severity, Map<String, Map<String, List<TestError>>>> errorsBySeverityMessageDescription = OsmValidator.getErrorsBySeverityMessageDescription(this.errors, filterToUse);
        ArrayList expandedPaths = new ArrayList();
        errorsBySeverityMessageDescription.forEach((severity, errorsByMessageDescription) -> {
            Map errorsWithEmptyMessageByDescription;
            GroupTreeNode severityNode = new GroupTreeNode(severity);
            rootNode.add(severityNode);
            if (oldSelectedRows.contains(severity)) {
                expandedPaths.add(new TreePath(new Object[]{rootNode, severityNode}));
            }
            if ((errorsWithEmptyMessageByDescription = (Map)errorsByMessageDescription.get("")) != null) {
                errorsWithEmptyMessageByDescription.forEach((description, errors) -> {
                    String msg = I18n.tr("{0} ({1})", description, errors.size());
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    severityNode.add(messageNode);
                    if (oldSelectedRows.contains(description)) {
                        expandedPaths.add(new TreePath(new Object[]{rootNode, severityNode, messageNode}));
                    }
                    errors.stream().map(DefaultMutableTreeNode::new).forEach(messageNode::add);
                });
            }
            errorsByMessageDescription.forEach((message, errorsByDescription) -> {
                GroupTreeNode groupNode;
                if (message.isEmpty()) {
                    return;
                }
                if (errorsByDescription.size() > 1) {
                    groupNode = new GroupTreeNode(message);
                    severityNode.add(groupNode);
                    if (oldSelectedRows.contains(message)) {
                        expandedPaths.add(new TreePath(new Object[]{rootNode, severityNode, groupNode}));
                    }
                } else {
                    groupNode = null;
                }
                errorsByDescription.forEach((description, errors) -> {
                    boolean emptyDescription;
                    boolean bl = emptyDescription = description == null || description.isEmpty();
                    String msg = groupNode != null ? I18n.tr("{0} ({1})", description, errors.size()) : (emptyDescription ? I18n.tr("{0} ({1})", message, errors.size()) : I18n.tr("{0} - {1} ({2})", message, description, errors.size()));
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    if (groupNode != null) {
                        groupNode.add(messageNode);
                    } else {
                        severityNode.add(messageNode);
                    }
                    if (oldSelectedRows.contains(description) || emptyDescription && oldSelectedRows.contains(message)) {
                        if (groupNode != null) {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, severityNode, groupNode, messageNode}));
                        } else {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, severityNode, messageNode}));
                        }
                    }
                    errors.stream().map(DefaultMutableTreeNode::new).forEach(messageNode::add);
                });
            });
        });
        this.valTreeModel.setRoot(rootNode);
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
        this.invalidationListeners.fireEvent(Runnable::run);
    }

    public void addInvalidationListener(Runnable listener) {
        this.invalidationListeners.addListener(listener);
    }

    public void removeInvalidationListener(Runnable listener) {
        this.invalidationListeners.removeListener(listener);
    }

    public final void setErrorList(List<TestError> errors) {
        this.errors = errors;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> newerrors) {
        if (this.errors == null) {
            return;
        }
        this.clearErrors();
        for (TestError error : newerrors) {
            if (error.isIgnored()) continue;
            this.errors.add(error);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void selectRelatedErrors(Collection<OsmPrimitive> primitives) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        this.walkAndSelectRelatedErrors(new TreePath(this.getRoot()), new HashSet<OsmPrimitive>(primitives)::contains, paths);
        this.getSelectionModel().clearSelection();
        for (TreePath path : paths) {
            this.expandPath(path);
            this.getSelectionModel().addSelectionPath(path);
        }
    }

    private void walkAndSelectRelatedErrors(TreePath p, Predicate<OsmPrimitive> isRelevant, Collection<TreePath> paths) {
        int count = this.getModel().getChildCount(p.getLastPathComponent());
        for (int i = 0; i < count; ++i) {
            Object child = this.getModel().getChild(p.getLastPathComponent(), i);
            if (this.getModel().isLeaf(child) && child instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)child).getUserObject() instanceof TestError) {
                TestError error = (TestError)((DefaultMutableTreeNode)child).getUserObject();
                if (!error.getPrimitives().stream().anyMatch(isRelevant)) continue;
                paths.add(p.pathByAddingChild(child));
                continue;
            }
            this.walkAndSelectRelatedErrors(p.pathByAddingChild(child), isRelevant, paths);
        }
    }

    public Set<? extends OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<? extends OsmPrimitive> filter) {
        this.filter = filter != null && filter.isEmpty() ? null : filter;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        this.setErrors(new ArrayList<TestError>(this.errors));
    }

    public void expandAll() {
        DefaultMutableTreeNode root = this.getRoot();
        int row = 0;
        Enumeration<TreeNode> children = root.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            children.nextElement();
            this.expandRow(row++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    private void clearErrors() {
        if (this.errors != null) {
            this.errors.clear();
        }
    }

    @Override
    public void destroy() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.removeDataSetListener(this);
        }
        this.clearErrors();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        if (this.errors != null) {
            HashSet deletedPrimitives = new HashSet(event.getPrimitives());
            this.errors.removeIf(error -> error.getPrimitives().stream().anyMatch(deletedPrimitives::contains));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
    }

    private static final class GroupTreeNode
    extends DefaultMutableTreeNode {
        GroupTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public String toString() {
            return I18n.tr("{0} ({1})", super.toString(), this.getLeafCount());
        }
    }
}

