/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED_FOCUS = new Color(-7361793);
    public static final Color BGCOLOR_SELECTED = new Color(-5258497);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void setBackgroundReadable(String key, TagTableModel model, boolean isSelected, boolean hasFocus, boolean isValue) {
        Color bgColor = UIManager.getColor("Table.background");
        if (!model.hasTag(key) && model.isCurrentPointInTime() || !model.oppositeHasTag(key) && model.isReferencePointInTime()) {
            bgColor = TwoColumnDiff.Item.DiffItemType.DELETED.getColor();
        } else if (!model.oppositeHasTag(key) && model.isCurrentPointInTime() || !model.hasTag(key) && model.isReferencePointInTime()) {
            bgColor = TwoColumnDiff.Item.DiffItemType.INSERTED.getColor();
        } else if (isValue && model.hasTag(key) && model.oppositeHasTag(key) && !model.hasSameValueAsOpposite(key)) {
            bgColor = TwoColumnDiff.Item.DiffItemType.CHANGED.getColor();
        }
        if (isSelected) {
            bgColor = hasFocus ? BGCOLOR_SELECTED_FOCUS : BGCOLOR_SELECTED;
        }
        GuiHelper.setBackgroundReadable(this, bgColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        String key = (String)value;
        TagTableModel model = this.getTagTableModel(table);
        String text = "";
        if (model.hasTag(key)) {
            switch (column) {
                case 0: {
                    text = key;
                    break;
                }
                case 1: {
                    text = model.getValue(key);
                    break;
                }
            }
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackgroundReadable(key, model, isSelected, table.hasFocus(), column == 1);
        return this;
    }

    protected TagTableModel getTagTableModel(JTable table) {
        return (TagTableModel)table.getModel();
    }
}

