/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSRule
implements Comparable<MapCSSRule> {
    public final Selector selector;
    public final Declaration declaration;

    public MapCSSRule(Selector selector, Declaration declaration) {
        this.selector = selector;
        this.declaration = declaration;
    }

    public void execute(Environment env) {
        this.declaration.execute(env);
    }

    @Override
    public int compareTo(MapCSSRule o) {
        return this.declaration.idx - o.declaration.idx;
    }

    public String toString() {
        return this.selector + " {\n  " + Utils.join("\n  ", this.declaration.instructions) + "\n}";
    }

    public static class Declaration {
        public final List<Instruction> instructions;
        public final int idx;

        public Declaration(List<Instruction> instructions, int idx) {
            this.instructions = instructions;
            this.idx = idx;
        }

        public void execute(Environment env) {
            for (Instruction i : this.instructions) {
                i.execute(env);
            }
        }

        public int hashCode() {
            return Objects.hash(this.instructions, this.idx);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Declaration that = (Declaration)obj;
            return this.idx == that.idx && Objects.equals(this.instructions, that.instructions);
        }

        public String toString() {
            return "Declaration [instructions=" + this.instructions + ", idx=" + this.idx + ']';
        }
    }
}

