/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggingPresetMenu that = (TaggingPresetMenu)o;
        return Objects.equals(this.getRawName(), that.getRawName());
    }

    public int hashCode() {
        return Objects.hash(this.getRawName());
    }

    @Override
    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("Optional tooltip text", this.group != null ? I18n.tr("Preset group {1} / {0}", this.getLocaleName(), this.group.getName()) : I18n.tr("Preset group {0}", this.getLocaleName()));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    private static Component copyMenuComponent(Component menuComponent) {
        if (menuComponent instanceof JMenu) {
            JMenu menu = (JMenu)menuComponent;
            JMenu result = new JMenu(menu.getAction());
            for (Component item : menu.getMenuComponents()) {
                result.add(TaggingPresetMenu.copyMenuComponent(item));
            }
            result.setText(menu.getText());
            return result;
        }
        if (menuComponent instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)menuComponent;
            JMenuItem result = new JMenuItem(menuItem.getAction());
            result.setText(menuItem.getText());
            return result;
        }
        if (menuComponent instanceof JSeparator) {
            return new JSeparator();
        }
        return menuComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (this.menu != null && s instanceof Component) {
            JPopupMenu pm = new JPopupMenu(this.getName());
            for (Component c : this.menu.getMenuComponents()) {
                pm.add(TaggingPresetMenu.copyMenuComponent(c));
            }
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo != null) {
                Point p = pointerInfo.getLocation();
                pm.show(Main.parent, p.x - Main.parent.getX(), p.y - Main.parent.getY());
            }
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu menu) {
        Component[] items = menu.getMenuComponents();
        PresetTextComparator comp = new PresetTextComparator();
        ArrayList<JMenuItem> sortarray = new ArrayList<JMenuItem>();
        int lastSeparator = 0;
        for (int i = 0; i < items.length; ++i) {
            Component item = items[i];
            if (item instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)item);
            }
            if (item instanceof JMenuItem) {
                sortarray.add((JMenuItem)item);
                if (i != items.length - 1) continue;
                TaggingPresetMenu.handleMenuItem(menu, comp, sortarray, lastSeparator);
                sortarray = new ArrayList();
                lastSeparator = 0;
                continue;
            }
            if (!(item instanceof JSeparator)) continue;
            TaggingPresetMenu.handleMenuItem(menu, comp, sortarray, lastSeparator);
            sortarray = new ArrayList();
            lastSeparator = i;
        }
    }

    private static void handleMenuItem(JMenu menu, PresetTextComparator comp, List<JMenuItem> sortarray, int lastSeparator) {
        sortarray.sort(comp);
        int pos = 0;
        for (JMenuItem menuItem : sortarray) {
            int oldPos = lastSeparator == 0 ? pos : pos + lastSeparator + 1;
            menu.add((Component)menuItem, oldPos);
            ++pos;
        }
    }

    private static class PresetTextComparator
    implements Comparator<JMenuItem>,
    Serializable {
        private PresetTextComparator() {
        }

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            if (MainApplication.getMenu().presetSearchAction.equals(o1.getAction())) {
                return -1;
            }
            if (MainApplication.getMenu().presetSearchAction.equals(o2.getAction())) {
                return 1;
            }
            return AlphanumComparator.getInstance().compare(o1.getText(), o2.getText());
        }
    }
}

