/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class TextContextualPopupMenu
extends JPopupMenu {
    private static final String EDITABLE = "editable";
    protected JTextComponent component;
    protected boolean undoRedo;
    protected final UndoAction undoAction = new UndoAction();
    protected final RedoAction redoAction = new RedoAction();
    protected final UndoManager undo = new UndoManager();
    protected final transient UndoableEditListener undoEditListener = e -> {
        this.undo.addEdit(e.getEdit());
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    };
    protected final transient PropertyChangeListener propertyChangeListener = evt -> {
        if (EDITABLE.equals(evt.getPropertyName())) {
            this.removeAll();
            this.addMenuEntries();
        }
    };

    protected TextContextualPopupMenu() {
    }

    protected TextContextualPopupMenu attach(JTextComponent component, boolean undoRedo) {
        if (component != null && !this.isAttached()) {
            this.component = component;
            this.undoRedo = undoRedo;
            if (undoRedo && component.isEditable()) {
                component.getDocument().addUndoableEditListener(this.undoEditListener);
                if (!GraphicsEnvironment.isHeadless()) {
                    component.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.undoAction);
                    component.getInputMap().put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), this.redoAction);
                }
            }
            this.addMenuEntries();
            component.addPropertyChangeListener(EDITABLE, this.propertyChangeListener);
        }
        return this;
    }

    private void addMenuEntries() {
        if (this.component.isEditable()) {
            if (this.undoRedo) {
                this.add(new JMenuItem(this.undoAction));
                this.add(new JMenuItem(this.redoAction));
                this.addSeparator();
            }
            this.addMenuEntry(this.component, I18n.tr("Cut", new Object[0]), "cut-to-clipboard", null);
        }
        this.addMenuEntry(this.component, I18n.tr("Copy", new Object[0]), "copy-to-clipboard", "copy");
        if (this.component.isEditable()) {
            this.addMenuEntry(this.component, I18n.tr("Paste", new Object[0]), "paste-from-clipboard", "paste");
            this.addMenuEntry(this.component, I18n.tr("Delete", new Object[0]), "delete-next", null);
        }
        this.addSeparator();
        this.addMenuEntry(this.component, I18n.tr("Select All", new Object[0]), "select-all", null);
    }

    protected TextContextualPopupMenu detach() {
        if (this.isAttached()) {
            this.component.removePropertyChangeListener(EDITABLE, this.propertyChangeListener);
            this.removeAll();
            if (this.undoRedo) {
                this.component.getDocument().removeUndoableEditListener(this.undoEditListener);
            }
            this.component = null;
        }
        return this;
    }

    public static PopupMenuLauncher enableMenuFor(JTextComponent component, boolean undoRedo) {
        PopupMenuLauncher launcher = new PopupMenuLauncher(new TextContextualPopupMenu().attach(component, undoRedo), true);
        component.addMouseListener(launcher);
        return launcher;
    }

    public static void disableMenuFor(JTextComponent component, PopupMenuLauncher launcher) {
        if (launcher.getMenu() instanceof TextContextualPopupMenu) {
            ((TextContextualPopupMenu)launcher.getMenu()).detach();
            component.removeMouseListener(launcher);
        }
    }

    public final boolean isAttached() {
        return this.component != null;
    }

    protected void addMenuEntry(JTextComponent component, String label, String actionName, String iconName) {
        Action action = component.getActionMap().get(actionName);
        if (action != null) {
            ImageIcon icon;
            JMenuItem mi = new JMenuItem(action);
            mi.setText(label);
            if (iconName != null && Config.getPref().getBoolean("text.popupmenu.useicons", true) && (icon = ImageProvider.get(iconName, ImageProvider.ImageSizes.SMALLICON)) != null) {
                mi.setIcon(icon);
            }
            this.add(mi);
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(I18n.tr("Redo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextContextualPopupMenu.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                Logging.trace(ex);
            }
            finally {
                this.updateRedoState();
                TextContextualPopupMenu.this.undoAction.updateUndoState();
            }
        }

        public void updateRedoState() {
            if (TextContextualPopupMenu.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Redo", new Object[0]));
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(I18n.tr("Undo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextContextualPopupMenu.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                Logging.trace(ex);
            }
            finally {
                this.updateUndoState();
                TextContextualPopupMenu.this.redoAction.updateRedoState();
            }
        }

        public void updateUndoState() {
            if (TextContextualPopupMenu.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextContextualPopupMenu.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", I18n.tr("Undo", new Object[0]));
            }
        }
    }
}

