/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.SettingVisitor;

public class ListListSetting
extends AbstractSetting<List<List<String>>> {
    public ListListSetting(List<List<String>> value) {
        super(value);
        this.consistencyTest();
    }

    public static ListListSetting create(Collection<Collection<String>> value) {
        if (value != null) {
            ArrayList<List<String>> valueList = new ArrayList<List<String>>(value.size());
            for (Collection<String> lst : value) {
                valueList.add(new ArrayList<String>(lst));
            }
            return new ListListSetting((List<List<String>>)valueList);
        }
        return new ListListSetting(null);
    }

    public ListListSetting copy() {
        if (this.value == null) {
            return new ListListSetting(null);
        }
        ArrayList copy = new ArrayList(((List)this.value).size());
        for (Collection lst : (List)this.value) {
            ArrayList lstCopy = new ArrayList(lst);
            copy.add(Collections.unmodifiableList(lstCopy));
        }
        return new ListListSetting(Collections.unmodifiableList(copy));
    }

    private void consistencyTest() {
        if (this.value != null) {
            if (((List)this.value).contains(null)) {
                throw new IllegalArgumentException("Error: Null as list element in preference setting");
            }
            for (Collection lst : (List)this.value) {
                if (!lst.contains(null)) continue;
                throw new IllegalArgumentException("Error: Null as inner list element in preference setting");
            }
        }
    }

    @Override
    public void visit(SettingVisitor visitor) {
        visitor.visit(this);
    }

    public ListListSetting getNullInstance() {
        return new ListListSetting(null);
    }
}

