/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;

public class DataIterator<T extends ExplicitVertexID>
implements Iterator<T> {
    private Edge<T>[] edges;
    private int edgesLength;
    private int edgeIteratorIndex;
    private Object type;
    private Edge nextEdge = null;
    private boolean source;
    private boolean negate;

    public DataIterator(Edge<T>[] edges, int edgesLength, Object type2, boolean source2, boolean negate2) {
        this.edges = edges;
        this.edgesLength = edgesLength;
        this.edgeIteratorIndex = 0;
        this.type = type2;
        this.source = source2;
        this.negate = negate2;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEdge != null) {
            return true;
        }
        for (int i2 = this.edgeIteratorIndex; i2 < this.edgesLength; ++i2) {
            Edge<T> edge = this.edges[i2];
            Object edgeType = edge.getType();
            if (this.negate) {
                if ((edgeType == null || edgeType.equals(this.type)) && (edgeType != null || edgeType == this.type)) continue;
                this.nextEdge = edge;
                this.edgeIteratorIndex = i2 + 1;
                return true;
            }
            if ((edgeType == null || !edgeType.equals(this.type)) && (edgeType != null || edgeType != this.type)) continue;
            this.nextEdge = edge;
            this.edgeIteratorIndex = i2 + 1;
            return true;
        }
        this.edgeIteratorIndex = this.edgesLength;
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            Edge tmp = this.nextEdge;
            this.nextEdge = null;
            return this.source ? tmp.getSource().getData() : tmp.getDestination().getData();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

