/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariableAnalysis
extends CompilerPass {
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(OptimizeDynScopesPass.class);

    @Override
    public String getLabel() {
        return "Live Variable Analysis";
    }

    @Override
    public Object previouslyRun(IRScope scope) {
        return scope.getLiveVariablesProblem();
    }

    private void collectNonLocalDirtyVars(IRClosure cl, Set<LocalVariable> vars, int minDepth) {
        for (BasicBlock bb : cl.getCFG().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Operand clArg;
                Variable res;
                if (i2 instanceof ResultInstr && (res = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && ((LocalVariable)res).getScopeDepth() > minDepth) {
                    vars.add((LocalVariable)res);
                }
                if (!(i2 instanceof ClosureAcceptingInstr) || !((clArg = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg()) instanceof WrappedIRClosure)) continue;
                this.collectNonLocalDirtyVars(((WrappedIRClosure)clArg).getClosure(), vars, minDepth + 1);
            }
        }
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        scope.computeScopeFlags();
        LiveVariablesProblem lvp = new LiveVariablesProblem(scope);
        if (scope instanceof IRClosure) {
            HashSet<LocalVariable> nlVars = new HashSet<LocalVariable>();
            EnumSet<IRFlags> flags2 = scope.getExecutionContext().getFlags();
            this.collectNonLocalDirtyVars((IRClosure)scope, nlVars, flags2.contains((Object)IRFlags.DYNSCOPE_ELIMINATED) ? -1 : 0);
            for (Variable variable : nlVars) {
                lvp.addDFVar(variable);
            }
            lvp.setVarsLiveOnScopeExit(nlVars);
        }
        lvp.compute_MOP_Solution();
        scope.putLiveVariablesProblem(lvp);
        return lvp;
    }

    @Override
    public boolean invalidate(IRScope scope) {
        super.invalidate(scope);
        scope.putLiveVariablesProblem(null);
        return true;
    }
}

