/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.contracts.ESDataFlowValue;
import org.jetbrains.kotlin.contracts.ESLambda;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.AndFunctor;
import org.jetbrains.kotlin.contracts.model.functors.EqualsFunctor;
import org.jetbrains.kotlin.contracts.model.functors.IsFunctor;
import org.jetbrains.kotlin.contracts.model.functors.NotFunctor;
import org.jetbrains.kotlin.contracts.model.functors.OrFunctor;
import org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.UNKNOWN_COMPUTATION;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bJ\u001d\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020$H\u0002J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010&*\u0006\u0012\u0002\b\u00030'H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010)*\u00020*H\u0002J\u0010\u0010+\u001a\u00020,*\u0006\u0012\u0002\b\u00030'H\u0002J\f\u0010-\u001a\u00020\u0002*\u00020.H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/contracts/EffectsExtractingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "extractOrGetCached", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "data", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getCallArgumentsAsComputations", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getFunctor", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isCallWithUnsupportedReceiver", "", "toComputation", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "frontend"})
public final class EffectsExtractingVisitor
extends KtVisitor<Computation, Unit> {
    private final BindingTrace trace;
    private final ModuleDescriptor moduleDescriptor;

    @NotNull
    public final Computation extractOrGetCached(@NotNull KtElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Computation computation = (Computation)this.trace.get(BindingContext.EXPRESSION_EFFECTS, element);
        if (computation != null) {
            Computation computation2;
            Computation it;
            Computation computation3 = it = (computation2 = computation);
            Intrinsics.checkExpressionValueIsNotNull(computation3, "it");
            return computation3;
        }
        Object r = element.accept(this, Unit.INSTANCE);
        Computation it = (Computation)r;
        this.trace.record(BindingContext.EXPRESSION_EFFECTS, element, it);
        return (Computation)r;
    }

    @Override
    @NotNull
    public Computation visitKtElement(@NotNull KtElement element, @NotNull Unit data) {
        Computation computation;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(data, "data");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, bindingContext);
        if (resolvedCall2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (this.isCallWithUnsupportedReceiver(resolvedCall3)) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        List<Computation> list2 = this.getCallArgumentsAsComputations(resolvedCall3);
        if (list2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        List<Computation> arguments2 = list2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (PsiContractsUtilsKt.isEqualsDescriptor(descriptor2)) {
            computation = new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new EqualsFunctor(false).invokeWithArguments(arguments2));
        } else if (descriptor2 instanceof ValueDescriptor) {
            DataFlowValue dataFlowValue = this.createDataFlowValue((KtExpression)element);
            if (dataFlowValue == null) {
                return UNKNOWN_COMPUTATION.INSTANCE;
            }
            computation = new ESDataFlowValue((ValueDescriptor)descriptor2, dataFlowValue);
        } else if (descriptor2 instanceof FunctionDescriptor) {
            KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
            Object object = this.getFunctor((FunctionDescriptor)descriptor2);
            if (object == null || (object = object.invokeWithArguments(arguments2)) == null) {
                object = kotlin.collections.CollectionsKt.emptyList();
            }
            computation = new CallComputation(kotlinType, (List<? extends ESEffect>)object);
        } else {
            computation = UNKNOWN_COMPUTATION.INSTANCE;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return UNKNOWN_COMPUTATION.INSTANCE;
    }

    @Override
    @NotNull
    public Computation visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Object object = KtPsiUtil.deparenthesize(expression2);
        if (object == null || (object = (Computation)object.accept(this, data)) == null) {
            object = UNKNOWN_COMPUTATION.INSTANCE;
        }
        return object;
    }

    @Override
    @NotNull
    public Computation visitConstantExpression(@NotNull KtConstantExpression expression2, @NotNull Unit data) {
        Object value;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        BindingContext bindingContext = this.trace.getBindingContext();
        KotlinType kotlinType = bindingContext.getType(expression2);
        if (kotlinType == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        if (compileTimeConstant == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
        Object t = value = compileTimeConstant2.getValue(type2);
        return t instanceof Boolean ? (Computation)ValuesKt.lift((Boolean)value) : (t == null ? (Computation)ESConstant.Companion.getNULL() : (Computation)UNKNOWN_COMPUTATION.INSTANCE);
    }

    @Override
    @NotNull
    public Computation visitIsExpression(@NotNull KtIsExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        KotlinType kotlinType = (KotlinType)this.trace.get(BindingContext.TYPE, expression2.getTypeReference());
        if (kotlinType == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        KotlinType rightType = kotlinType;
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "expression.leftHandSide");
        Computation arg = this.extractOrGetCached(ktExpression);
        return new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new IsFunctor(rightType, expression2.isNegated()).invokeWithArguments(kotlin.collections.CollectionsKt.listOf(arg)));
    }

    @Override
    @NotNull
    public Computation visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation left = this.extractOrGetCached(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation right = this.extractOrGetCached(ktExpression2);
        List<Computation[]> args = kotlin.collections.CollectionsKt.listOf(new Computation[]{left, right});
        IElementType iElementType = expression2.getOperationToken();
        return Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ) ? (Computation)new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new EqualsFunctor(true).invokeWithArguments(args)) : (Intrinsics.areEqual(iElementType, KtTokens.EQEQ) ? (Computation)new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new EqualsFunctor(false).invokeWithArguments(args)) : (Intrinsics.areEqual(iElementType, KtTokens.ANDAND) ? (Computation)new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new AndFunctor().invokeWithArguments(args)) : (Intrinsics.areEqual(iElementType, KtTokens.OROR) ? (Computation)new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new OrFunctor().invokeWithArguments(args)) : (Computation)UNKNOWN_COMPUTATION.INSTANCE)));
    }

    @Override
    @NotNull
    public Computation visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull Unit data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            return UNKNOWN_COMPUTATION.INSTANCE;
        }
        Computation arg = this.extractOrGetCached(ktExpression);
        IElementType iElementType = expression2.getOperationToken();
        return Intrinsics.areEqual(iElementType, KtTokens.EXCL) ? (Computation)new CallComputation(DefaultBuiltIns.Companion.getInstance().getBooleanType(), new NotFunctor().invokeWithArguments(arg)) : (Computation)UNKNOWN_COMPUTATION.INSTANCE;
    }

    private final Computation toComputation(@NotNull ReceiverValue $receiver) {
        ReceiverValue receiverValue = $receiver;
        return receiverValue instanceof ExpressionReceiver ? this.extractOrGetCached(((ExpressionReceiver)$receiver).getExpression()) : (Computation)UNKNOWN_COMPUTATION.INSTANCE;
    }

    private final DataFlowValue createDataFlowValue(@NotNull KtExpression $receiver) {
        KotlinType kotlinType = this.trace.getType($receiver);
        if (kotlinType == null) {
            return null;
        }
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        return DataFlowValueFactory.createDataFlowValue($receiver, kotlinType, bindingContext, this.moduleDescriptor);
    }

    private final Functor getFunctor(@NotNull FunctionDescriptor $receiver) {
        Functor functor = (Functor)this.trace.get(BindingContext.FUNCTOR, $receiver);
        if (functor != null) {
            Functor functor2;
            Functor it = functor2 = functor;
            return it;
        }
        Functor functor3 = new ContractInterpretationDispatcher().resolveFunctor($receiver);
        if (functor3 == null) {
            return null;
        }
        Functor functor4 = functor3;
        this.trace.record(BindingContext.FUNCTOR, $receiver, functor4);
        return functor4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallWithUnsupportedReceiver(@NotNull ResolvedCall<?> $receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        Object object;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3;
        Object object2;
        ReceiverValue receiverValue = $receiver.getExtensionReceiver();
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        if ((object2 = (ExpressionReceiver)receiverValue) != null && (object2 = object2.getExpression()) != null) {
            KtElement ktElement = (KtElement)object2;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            resolvedCall3 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        } else {
            resolvedCall3 = null;
        }
        if (Intrinsics.areEqual(resolvedCall3, $receiver)) return true;
        ReceiverValue receiverValue2 = $receiver.getDispatchReceiver();
        if (!(receiverValue2 instanceof ExpressionReceiver)) {
            receiverValue2 = null;
        }
        if ((object = (ExpressionReceiver)receiverValue2) != null && (object = object.getExpression()) != null) {
            KtElement ktElement = (KtElement)object;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
            resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        } else {
            resolvedCall2 = null;
        }
        if (Intrinsics.areEqual(resolvedCall2, $receiver)) return true;
        if (!Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Computation> getCallArgumentsAsComputations(@NotNull ResolvedCall<?> $receiver) {
        List arguments2 = new ArrayList();
        ReceiverValue receiverValue = $receiver.getExtensionReceiver();
        CollectionsKt.addIfNotNull(arguments2, receiverValue != null ? this.toComputation(receiverValue) : null);
        ReceiverValue receiverValue2 = $receiver.getDispatchReceiver();
        CollectionsKt.addIfNotNull(arguments2, receiverValue2 != null ? this.toComputation(receiverValue2) : null);
        List<ResolvedValueArgument> list2 = $receiver.getValueArgumentsByIndex();
        if (list2 != null) {
            Iterable $receiver$iv = list2;
            for (Object item$iv : $receiver$iv) {
                Computation computation;
                Object valueArgument;
                Object object;
                void it;
                ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)item$iv;
                Collection collection = arguments2;
                Object v3 = it;
                if (!(v3 instanceof ExpressionValueArgument)) {
                    v3 = null;
                }
                if ((object = (ExpressionValueArgument)v3) == null || (object = ((ExpressionValueArgument)object).getValueArgument()) == null) {
                    return null;
                }
                Object object2 = valueArgument = object;
                if (object2 instanceof KtLambdaArgument) {
                    computation = new ESLambda(((KtLambdaArgument)valueArgument).getLambdaExpression());
                } else {
                    KtExpression ktExpression = valueArgument.getArgumentExpression();
                    if (ktExpression == null) {
                        return null;
                    }
                    computation = this.extractOrGetCached(ktExpression);
                }
                Computation computation2 = computation;
                collection.add(computation2);
            }
        } else {
            return null;
        }
        List cfr_ignored_0 = (List)((Collection)arguments2);
        return arguments2;
    }

    public EffectsExtractingVisitor(@NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        this.trace = trace;
        this.moduleDescriptor = moduleDescriptor;
    }
}

