/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;

public class DataFlowInfoForArgumentsImpl
extends MutableDataFlowInfoForArguments {
    @Nullable
    private Map<ValueArgument, DataFlowInfo> infoMap = null;
    @Nullable
    private Map<ValueArgument, ValueArgument> nextArgument = null;
    @Nullable
    private DataFlowInfo resultInfo;

    public DataFlowInfoForArgumentsImpl(@NotNull DataFlowInfo initialInfo, @NotNull Call call2) {
        super(initialInfo);
        this.initNextArgMap(call2.getValueArguments());
    }

    private void initNextArgMap(@NotNull List<? extends ValueArgument> valueArguments) {
        Iterator<? extends ValueArgument> iterator2 = valueArguments.iterator();
        ValueArgument prev = null;
        while (iterator2.hasNext()) {
            ValueArgument argument = iterator2.next();
            if (prev != null) {
                if (this.nextArgument == null) {
                    this.nextArgument = new HashMap<ValueArgument, ValueArgument>();
                }
                this.nextArgument.put(prev, argument);
            }
            prev = argument;
        }
    }

    @Override
    @NotNull
    public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
        DataFlowInfo infoForArgument;
        DataFlowInfo dataFlowInfo = infoForArgument = this.infoMap == null ? null : this.infoMap.get(valueArgument);
        if (infoForArgument == null) {
            return this.initialDataFlowInfo;
        }
        return this.initialDataFlowInfo.and(infoForArgument);
    }

    @Override
    public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
        ValueArgument next;
        ValueArgument valueArgument2 = next = this.nextArgument == null ? null : this.nextArgument.get(valueArgument);
        if (next != null) {
            if (this.infoMap == null) {
                this.infoMap = new HashMap<ValueArgument, DataFlowInfo>();
            }
            this.infoMap.put(next, dataFlowInfo);
            return;
        }
        this.resultInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getResultInfo() {
        if (this.resultInfo == null) {
            return this.initialDataFlowInfo;
        }
        return this.initialDataFlowInfo.and(this.resultInfo);
    }

    @Override
    public void updateResultInfo(@NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo.equals(DataFlowInfo.Companion.getEMPTY())) {
            return;
        }
        if (this.resultInfo == null) {
            this.resultInfo = this.initialDataFlowInfo;
        }
        this.resultInfo = this.resultInfo.and(dataFlowInfo);
    }
}

