/****************************************************************************
**
*W  objpcgel.h                  GAP source                       Frank Celler
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
*/

#ifndef libGAP_GAP_OBJPCGEL_H
#define libGAP_GAP_OBJPCGEL_H


/****************************************************************************
**

*V  PCWP_FIRST_ENTRY  . . . . . . . . . . . . . . first entry in subrep of AW
*/
#define libGAP_PCWP_FIRST_ENTRY        libGAP_AWP_FIRST_FREE


/****************************************************************************
**
*V  PCWP_NAMES  . . . . . . . . . . . . . . . . . . . . . . . . list of names
*/
#define libGAP_PCWP_NAMES              (libGAP_PCWP_FIRST_ENTRY+1)


/****************************************************************************
**
*V  PCWP_COLLECTOR  . . . . . . . . . . . . . . . . . . . .  collector to use
*/
#define libGAP_PCWP_COLLECTOR          (libGAP_PCWP_FIRST_ENTRY+2)


/****************************************************************************
**
*V  PCWP_FIRST_FREE . . . . . . . . . . . . .  first free position for subrep
*/
#define libGAP_PCWP_FIRST_FREE         (libGAP_PCWP_FIRST_ENTRY+3)


/****************************************************************************
**
*V  COLLECTOR_PCWORD( <obj> ) . . . . . . . . . . . . . .  collector of <obj>
*/
#define libGAP_COLLECTOR_PCWORD(obj) \
    ( libGAP_ELM_PLIST( libGAP_TYPE_DATOBJ(obj), libGAP_PCWP_COLLECTOR ) )


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**


*F  InitInfoPcElements()  . . . . . . . . . . . . . . table of init functions
*/
libGAP_StructInitInfo * libGAP_InitInfoPcElements ( void );


#endif // GAP_OBJPCGEL_H

/****************************************************************************
**

*E  objpcgel.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
