/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.connector.basic.ArtifactTransportListener;
import org.eclipse.aether.connector.basic.ChecksumValidator;
import org.eclipse.aether.connector.basic.MetadataTransportListener;
import org.eclipse.aether.connector.basic.PartialFile;
import org.eclipse.aether.connector.basic.TransferTransportListener;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.eclipse.aether.util.concurrency.WorkerThreadFactory;

final class BasicRepositoryConnector
implements RepositoryConnector {
    private static final String CONFIG_PROP_THREADS = "aether.connector.basic.threads";
    private static final String CONFIG_PROP_RESUME = "aether.connector.resumeDownloads";
    private static final String CONFIG_PROP_RESUME_THRESHOLD = "aether.connector.resumeThreshold";
    private static final String CONFIG_PROP_SMART_CHECKSUMS = "aether.connector.smartChecksums";
    private final Logger logger;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final Transporter transporter;
    private final RepositoryLayout layout;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final PartialFile.Factory partialFileFactory;
    private final int maxThreads;
    private final boolean smartChecksums;
    private final boolean persistedChecksums;
    private Executor executor;
    private boolean closed;

    public BasicRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        try {
            this.layout = layoutProvider.newRepositoryLayout(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        try {
            this.transporter = transporterProvider.newTransporter(session, repository);
        }
        catch (NoTransporterException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        this.checksumPolicyProvider = checksumPolicyProvider;
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.logger = logger;
        this.maxThreads = ConfigUtils.getInteger((RepositorySystemSession)session, (int)5, (String[])new String[]{CONFIG_PROP_THREADS, "maven.artifact.threads"});
        this.smartChecksums = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_SMART_CHECKSUMS});
        this.persistedChecksums = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.persistedChecksums"});
        boolean resumeDownloads = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.resumeDownloads." + repository.getId(), CONFIG_PROP_RESUME});
        long resumeThreshold = ConfigUtils.getLong((RepositorySystemSession)session, (long)65536L, (String[])new String[]{"aether.connector.resumeThreshold." + repository.getId(), CONFIG_PROP_RESUME_THRESHOLD});
        int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout"});
        this.partialFileFactory = new PartialFile.Factory(resumeDownloads, resumeThreshold, requestTimeout, logger);
    }

    private Executor getExecutor(Collection<?> artifacts, Collection<?> metadatas) {
        if (this.maxThreads <= 1) {
            return DirectExecutor.INSTANCE;
        }
        int tasks = BasicRepositoryConnector.safe(artifacts).size() + BasicRepositoryConnector.safe(metadatas).size();
        if (tasks <= 1) {
            return DirectExecutor.INSTANCE;
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new WorkerThreadFactory(this.getClass().getSimpleName() + '-' + this.repository.getHost() + '-'));
        }
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.transporter.close();
        }
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        TransferTransportListener listener;
        TransferEvent.Builder builder;
        TransferResource resource;
        URI location;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        Executor executor = this.getExecutor(artifactDownloads, metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (MetadataDownload metadataDownload : BasicRepositoryConnector.safe(metadataDownloads)) {
            location = this.layout.getLocation(metadataDownload.getMetadata(), false);
            resource = this.newTransferResource(location, metadataDownload.getFile(), metadataDownload.getTrace());
            builder = this.newEventBuilder(resource, false, false);
            listener = new MetadataTransportListener((MetadataTransfer)metadataDownload, this.repository, builder);
            ChecksumPolicy checksumPolicy = this.newChecksumPolicy(metadataDownload.getChecksumPolicy(), resource);
            List checksums = null;
            if (checksumPolicy != null) {
                checksums = this.layout.getChecksums(metadataDownload.getMetadata(), false, location);
            }
            GetTaskRunner task = new GetTaskRunner(location, metadataDownload.getFile(), checksumPolicy, checksums, listener);
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        for (ArtifactDownload artifactDownload : BasicRepositoryConnector.safe(artifactDownloads)) {
            TaskRunner task;
            location = this.layout.getLocation(artifactDownload.getArtifact(), false);
            resource = this.newTransferResource(location, artifactDownload.getFile(), artifactDownload.getTrace());
            builder = this.newEventBuilder(resource, false, artifactDownload.isExistenceCheck());
            listener = new ArtifactTransportListener((ArtifactTransfer)artifactDownload, this.repository, builder);
            if (artifactDownload.isExistenceCheck()) {
                task = new PeekTaskRunner(location, listener);
            } else {
                ChecksumPolicy checksumPolicy = this.newChecksumPolicy(artifactDownload.getChecksumPolicy(), resource);
                List checksums = null;
                if (checksumPolicy != null) {
                    checksums = this.layout.getChecksums(artifactDownload.getArtifact(), false, location);
                }
                task = new GetTaskRunner(location, artifactDownload.getFile(), checksumPolicy, checksums, listener);
            }
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        errorForwarder.await();
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTaskRunner task;
        List checksums;
        TransferTransportListener listener;
        TransferEvent.Builder builder;
        TransferResource resource;
        URI location;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        for (ArtifactUpload artifactUpload : BasicRepositoryConnector.safe(artifactUploads)) {
            location = this.layout.getLocation(artifactUpload.getArtifact(), true);
            resource = this.newTransferResource(location, artifactUpload.getFile(), artifactUpload.getTrace());
            builder = this.newEventBuilder(resource, true, false);
            listener = new ArtifactTransportListener((ArtifactTransfer)artifactUpload, this.repository, builder);
            checksums = this.layout.getChecksums(artifactUpload.getArtifact(), true, location);
            task = new PutTaskRunner(location, artifactUpload.getFile(), checksums, listener);
            task.run();
        }
        for (MetadataUpload metadataUpload : BasicRepositoryConnector.safe(metadataUploads)) {
            location = this.layout.getLocation(metadataUpload.getMetadata(), true);
            resource = this.newTransferResource(location, metadataUpload.getFile(), metadataUpload.getTrace());
            builder = this.newEventBuilder(resource, true, false);
            listener = new MetadataTransportListener((MetadataTransfer)metadataUpload, this.repository, builder);
            checksums = this.layout.getChecksums(metadataUpload.getMetadata(), true, location);
            task = new PutTaskRunner(location, metadataUpload.getFile(), checksums, listener);
            task.run();
        }
    }

    private static <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private TransferResource newTransferResource(URI path, File file, RequestTrace trace) {
        return new TransferResource(this.repository.getId(), this.repository.getUrl(), path.toString(), file, trace);
    }

    private TransferEvent.Builder newEventBuilder(TransferResource resource, boolean upload, boolean peek) {
        TransferEvent.Builder builder = new TransferEvent.Builder(this.session, resource);
        if (upload) {
            builder.setRequestType(TransferEvent.RequestType.PUT);
        } else if (!peek) {
            builder.setRequestType(TransferEvent.RequestType.GET);
        } else {
            builder.setRequestType(TransferEvent.RequestType.GET_EXISTENCE);
        }
        return builder;
    }

    private ChecksumPolicy newChecksumPolicy(String policy, TransferResource resource) {
        return this.checksumPolicyProvider.newChecksumPolicy(this.session, this.repository, resource, policy);
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    private static class DirectExecutor
    implements Executor {
        static final Executor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    class PutTaskRunner
    extends TaskRunner {
        private final File file;
        private final Collection<RepositoryLayout.Checksum> checksums;

        public PutTaskRunner(URI path, File file, List<RepositoryLayout.Checksum> checksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "source file cannot be null");
            this.checksums = BasicRepositoryConnector.safe(checksums);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.put(new PutTask(this.path).setDataFile(this.file).setListener((TransportListener)this.listener));
            this.uploadChecksums(this.file, this.path);
        }

        private void uploadChecksums(File file, URI location) {
            if (this.checksums.isEmpty()) {
                return;
            }
            try {
                HashSet<String> algos = new HashSet<String>();
                for (RepositoryLayout.Checksum checksum : this.checksums) {
                    algos.add(checksum.getAlgorithm());
                }
                Map sumsByAlgo = ChecksumUtils.calc((File)file, algos);
                for (RepositoryLayout.Checksum checksum : this.checksums) {
                    this.uploadChecksum(checksum.getLocation(), sumsByAlgo.get(checksum.getAlgorithm()));
                }
            }
            catch (IOException e) {
                String msg = "Failed to upload checksums for " + file + ": " + e.getMessage();
                if (BasicRepositoryConnector.this.logger.isDebugEnabled()) {
                    BasicRepositoryConnector.this.logger.warn(msg, (Throwable)e);
                }
                BasicRepositoryConnector.this.logger.warn(msg);
            }
        }

        private void uploadChecksum(URI location, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                BasicRepositoryConnector.this.transporter.put(new PutTask(location).setDataString((String)checksum));
            }
            catch (Exception e) {
                String msg = "Failed to upload checksum " + location + ": " + e.getMessage();
                if (BasicRepositoryConnector.this.logger.isDebugEnabled()) {
                    BasicRepositoryConnector.this.logger.warn(msg, (Throwable)e);
                }
                BasicRepositoryConnector.this.logger.warn(msg);
            }
        }
    }

    class GetTaskRunner
    extends TaskRunner
    implements PartialFile.RemoteAccessChecker,
    ChecksumValidator.ChecksumFetcher {
        private final File file;
        private final ChecksumValidator checksumValidator;

        public GetTaskRunner(URI path, File file, ChecksumPolicy checksumPolicy, List<RepositoryLayout.Checksum> checksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "destination file cannot be null");
            this.checksumValidator = new ChecksumValidator(BasicRepositoryConnector.this.logger, file, BasicRepositoryConnector.this.fileProcessor, this, checksumPolicy, BasicRepositoryConnector.safe(checksums));
        }

        @Override
        public void checkRemoteAccess() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }

        @Override
        public boolean fetchChecksum(URI remote, File local) throws Exception {
            try {
                BasicRepositoryConnector.this.transporter.get(new GetTask(remote).setDataFile(local));
            }
            catch (Exception e) {
                if (BasicRepositoryConnector.this.transporter.classify((Throwable)e) == 1) {
                    return false;
                }
                throw e;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.fileProcessor.mkdirs(this.file.getParentFile());
            PartialFile partFile = BasicRepositoryConnector.this.partialFileFactory.newInstance(this.file, this);
            if (partFile == null) {
                BasicRepositoryConnector.this.logger.debug("Concurrent download of " + this.file + " just finished, skipping download");
                return;
            }
            try {
                File tmp = partFile.getFile();
                this.listener.setChecksumCalculator(this.checksumValidator.newChecksumCalculator(tmp));
                int firstTrial = 0;
                int lastTrial = 1;
                int trial = firstTrial;
                while (true) {
                    boolean resume = partFile.isResume() && trial <= firstTrial;
                    GetTask task = new GetTask(this.path).setDataFile(tmp, resume).setListener((TransportListener)this.listener);
                    BasicRepositoryConnector.this.transporter.get(task);
                    try {
                        this.checksumValidator.validate(this.listener.getChecksums(), BasicRepositoryConnector.this.smartChecksums ? task.getChecksums() : null);
                    }
                    catch (ChecksumFailureException e) {
                        boolean retry;
                        boolean bl = retry = trial < lastTrial && e.isRetryWorthy();
                        if (!retry && !this.checksumValidator.handle(e)) {
                            throw e;
                        }
                        this.listener.transferCorrupted((Exception)((Object)e));
                        if (!retry) break;
                        this.checksumValidator.retry();
                        ++trial;
                        continue;
                    }
                    break;
                }
                BasicRepositoryConnector.this.fileProcessor.move(tmp, this.file);
                if (BasicRepositoryConnector.this.persistedChecksums) {
                    this.checksumValidator.commit();
                }
            }
            finally {
                partFile.close();
                this.checksumValidator.close();
            }
        }
    }

    class PeekTaskRunner
    extends TaskRunner {
        public PeekTaskRunner(URI path, TransferTransportListener<?> listener) {
            super(path, listener);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }
    }

    abstract class TaskRunner
    implements Runnable {
        protected final URI path;
        protected final TransferTransportListener<?> listener;

        public TaskRunner(URI path, TransferTransportListener<?> listener) {
            this.path = path;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.transferInitiated();
                this.runTask();
                this.listener.transferSucceeded();
            }
            catch (Exception e) {
                this.listener.transferFailed(e, BasicRepositoryConnector.this.transporter.classify((Throwable)e));
            }
        }

        protected abstract void runTask() throws Exception;
    }
}

