/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Vector;

public class RectangleFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = 184722075881789163L;
    private int rectangleFigureSerializedDataVersion = 1;

    public RectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public RectangleFigure(Point point, Point point2) {
        this.basicDisplayBox(point, point2);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    public Vector handles() {
        Vector vector = new Vector();
        BoxHandleKit.addHandles(this, vector);
        return vector;
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
    }

    public String getMap() {
        String string = (String)this.getAttribute("Sensitive");
        if (string != null && string.length() > 0) {
            try {
                string = URLDecoder.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle rectangle = this.displayBox();
            return "<area shape=\"rect\" coords=\"" + rectangle.x + "," + rectangle.y + "," + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height) + "\" href=\"" + string + "\" />\n";
        }
        return "";
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
    }
}

