/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.TextHolderFigure;

public class FloatingTextArea {
    protected JScrollPane editScrollContainer;
    protected JTextArea textArea;
    protected DrawingView view;
    private TextHolderFigure editedFigure;
    private FigureListener figureHandler = new FigureAdapter(){

        @Override
        public void attributeChanged(FigureEvent figureEvent) {
            FloatingTextArea.this.updateWidget();
        }
    };

    public FloatingTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.editScrollContainer = new JScrollPane(this.textArea, 22, 31);
        this.editScrollContainer.setCursor(Cursor.getPredefinedCursor(0));
        this.editScrollContainer.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void createOverlay(DrawingView drawingView) {
        this.createOverlay(drawingView, null);
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void createOverlay(DrawingView drawingView, TextHolderFigure textHolderFigure) {
        drawingView.getComponent().add((Component)this.editScrollContainer, 0);
        this.editedFigure = textHolderFigure;
        this.view = drawingView;
        if (this.editedFigure != null) {
            this.editedFigure.addFigureListener(this.figureHandler);
            this.updateWidget();
        }
    }

    protected void updateWidget() {
        Font font = this.editedFigure.getFont();
        font = font.deriveFont(font.getStyle(), (float)((double)this.editedFigure.getFontSize() * this.view.getScaleFactor()));
        this.textArea.setFont(font);
        this.textArea.setForeground(this.editedFigure.getTextColor());
        this.textArea.setBackground(this.editedFigure.getFillColor());
    }

    public void setBounds(Rectangle2D.Double double_, String string) {
        this.textArea.setText(string);
        this.editScrollContainer.setBounds(this.view.drawingToView(double_));
        this.editScrollContainer.setVisible(true);
        this.textArea.setCaretPosition(0);
        this.textArea.requestFocus();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public Dimension getPreferredSize(int n) {
        return new Dimension(this.textArea.getWidth(), this.textArea.getHeight());
    }

    public void endOverlay() {
        this.view.getComponent().requestFocus();
        if (this.editScrollContainer != null) {
            this.editScrollContainer.setVisible(false);
            this.view.getComponent().remove(this.editScrollContainer);
            Rectangle rectangle = this.editScrollContainer.getBounds();
            this.view.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.editedFigure != null) {
            this.editedFigure.removeFigureListener(this.figureHandler);
            this.editedFigure = null;
        }
    }
}

