// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepBndLib_HeaderFile
#define _BRepBndLib_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
class TopoDS_Shape;
class Bnd_Box;


//! This package provides the bounding boxes for curves
//! and surfaces from BRepAdaptor.
//! Functions to add a topological shape to a bounding box
class BRepBndLib 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Adds the shape S to the bounding box B.
  //! More precisely are successively added to B:
  //! -   each face of S; the triangulation of the face is used if it exists,
  //! -   then each edge of S which does not belong to a face,
  //! the polygon of the edge is used if it exists
  //! -   and last each vertex of S which does not belong to an edge.
  //! After each elementary operation, the bounding box B is
  //! enlarged by the tolerance value of the relative sub-shape.
  //! When working with the triangulation of a face this value of
  //! enlargement is the sum of the triangulation deflection and
  //! the face tolerance. When working with the
  //! polygon of an edge this value of enlargement is
  //! the sum of the polygon deflection and the edge tolerance.
  //! Warning
  //! -   This algorithm is time consuming if triangulation has not
  //! been inserted inside the data structure of the shape S.
  //! -   The resulting bounding box may be somewhat larger than the object.
  Standard_EXPORT static   void Add (const TopoDS_Shape& S, Bnd_Box& B, const Standard_Boolean useTriangulation = Standard_True) ;
  
  //! Adds the shape S to the bounding box B.
  //! This is a quick algorithm but only works if the shape S is
  //! composed of polygonal planar faces, as is the case if S is
  //! an approached polyhedral representation of an exact
  //! shape. Pay particular attention to this because this
  //! condition is not checked and, if it not respected, an error
  //! may occur in the algorithm for which the bounding box is built.
  //! Note that the resulting bounding box is not enlarged by the
  //! tolerance value of the sub-shapes as is the case with the
  //! Add function. So the added part of the resulting bounding
  //! box is closer to the shape S.
  Standard_EXPORT static   void AddClose (const TopoDS_Shape& S, Bnd_Box& B) ;




protected:





private:





};







#endif // _BRepBndLib_HeaderFile
