// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSelect_SplineToBSpline_HeaderFile
#define _IGESSelect_SplineToBSpline_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSelect_SplineToBSpline.hxx>

#include <Standard_Boolean.hxx>
#include <Handle_Interface_CopyControl.hxx>
#include <IFSelect_Transformer.hxx>
#include <Handle_Interface_Protocol.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
#include <Handle_Standard_Transient.hxx>
class Interface_CopyControl;
class Interface_Graph;
class Interface_Protocol;
class Interface_CheckIterator;
class Interface_InterfaceModel;
class Standard_Transient;
class TCollection_AsciiString;


//! This type of Transformer allows to convert Spline Curves (IGES
//! type 112) and Surfaces (IGES Type 126) to BSpline Curves (IGES
//! type 114) and Surfac (IGES Type 128). All other entities are
//! rebuilt as identical but on the basis of this conversion.
//!
//! It also gives an option to, either convert as such (i.e. each
//! starting part of the spline becomes a segment of the bspline,
//! with continuity C0 between segments), or try to increase
//! continuity as far as possible to C1 or to C2.
//!
//! It does nothing if the starting model contains no Spline
//! Curve (IGES Type 112) or Surface (IGES Type 126). Else,
//! converting and rebuilding implies copying of entities.
class IGESSelect_SplineToBSpline : public IFSelect_Transformer
{

public:

  
  //! Creates a Transformer SplineToBSpline. If <tryC2> is True,
  //! it will in addition try to upgrade continuity up to C2.
  Standard_EXPORT IGESSelect_SplineToBSpline(const Standard_Boolean tryC2);
  
  //! Returns the option TryC2 given at creation time
  Standard_EXPORT   Standard_Boolean OptionTryC2()  const;
  
  //! Performs the transformation, if there is at least one Spline
  //! Curve (112) or Surface (126). Does nothing if there is none.
  Standard_EXPORT   Standard_Boolean Perform (const Interface_Graph& G, const Handle(Interface_Protocol)& protocol, Interface_CheckIterator& checks, Handle(Interface_InterfaceModel)& newmod) ;
  
  //! Returns the transformed entities.
  //! If original data contained no Spline Curve or Surface,
  //! the result is identity : <entto> = <entfrom>
  //! Else, the copied counterpart is returned : for a Spline Curve
  //! or Surface, it is a converted BSpline Curve or Surface. Else,
  //! it is the result of general service Copy (rebuilt as necessary
  //! by BSPlines replacing Splines).
  Standard_EXPORT   Standard_Boolean Updated (const Handle(Standard_Transient)& entfrom, Handle(Standard_Transient)& entto)  const;
  
  //! Returns a text which defines the way a Transformer works :
  //! "Conversion Spline to BSpline" and as opted,
  //! " trying to upgrade continuity"
  Standard_EXPORT   TCollection_AsciiString Label()  const;




  DEFINE_STANDARD_RTTI(IGESSelect_SplineToBSpline)

protected:




private: 


  Standard_Boolean thetryc2;
  Standard_Boolean thefound;
  Handle(Interface_CopyControl) themap;


};







#endif // _IGESSelect_SplineToBSpline_HeaderFile
