// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Law_Linear_HeaderFile
#define _Law_Linear_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Law_Linear.hxx>

#include <Standard_Real.hxx>
#include <Law_Function.hxx>
#include <GeomAbs_Shape.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Law_Function.hxx>
class Standard_OutOfRange;
class TColStd_Array1OfReal;
class Law_Function;


//! Describes an linear evolution law.
class Law_Linear : public Law_Function
{

public:

  
  //! Constructs an empty linear evolution law.
  Standard_EXPORT Law_Linear();
  

  //! Defines this linear evolution law by assigning both:
  //! -   the bounds Pdeb and Pfin of the parameter, and
  //! -   the values Valdeb and Valfin of the function at these
  //! two parametric bounds.
  Standard_EXPORT   void Set (const Standard_Real Pdeb, const Standard_Real Valdeb, const Standard_Real Pfin, const Standard_Real Valfin) ;
  
  //! Returns GeomAbs_CN
  Standard_EXPORT   GeomAbs_Shape Continuity()  const;
  
  //! Returns  1
  Standard_EXPORT   Standard_Integer NbIntervals (const GeomAbs_Shape S)  const;
  
  Standard_EXPORT   void Intervals (TColStd_Array1OfReal& T, const GeomAbs_Shape S)  const;
  
  //! Returns the value of this function at the point of parameter X.
  Standard_EXPORT   Standard_Real Value (const Standard_Real X) ;
  

  //! Returns the value F and the first derivative D of this
  //! function at the point of parameter X.
  Standard_EXPORT   void D1 (const Standard_Real X, Standard_Real& F, Standard_Real& D) ;
  
  //! Returns the value, first and second derivatives
  //! at parameter X.
  Standard_EXPORT   void D2 (const Standard_Real X, Standard_Real& F, Standard_Real& D, Standard_Real& D2) ;
  
  //! Returns a  law equivalent of  <me>  between
  //! parameters <First>  and <Last>. <Tol>  is used  to
  //! test for 3d points confusion.
  //! It is usfule to determines the derivatives
  //! in these values <First> and <Last> if
  //! the Law is not Cn.
  Standard_EXPORT   Handle(Law_Function) Trim (const Standard_Real PFirst, const Standard_Real PLast, const Standard_Real Tol)  const;
  
  //! Returns the parametric bounds of the function.
  Standard_EXPORT   void Bounds (Standard_Real& PFirst, Standard_Real& PLast) ;




  DEFINE_STANDARD_RTTI(Law_Linear)

protected:




private: 


  Standard_Real valdeb;
  Standard_Real valfin;
  Standard_Real pdeb;
  Standard_Real pfin;


};







#endif // _Law_Linear_HeaderFile
