// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Storage_Root_HeaderFile
#define _Storage_Root_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Storage_Root.hxx>

#include <TCollection_AsciiString.hxx>
#include <Handle_Standard_Persistent.hxx>
#include <Standard_Integer.hxx>
#include <MMgt_TShared.hxx>
class Standard_Persistent;
class Storage_Schema;
class TCollection_AsciiString;



//! A root object extracted from a Storage_Data object.
//! A Storage_Root encapsulates a persistent
//! object which is a root of a Storage_Data object.
//! It contains additional information: the name and
//! the data type of the persistent object.
//! When retrieving a Storage_Data object from a
//! container (for example, a file) you access its
//! roots with the function Roots which returns a
//! sequence of root objects. The provided functions
//! allow you to request information about each root of the sequence.
//! You do not create explicit roots: when inserting
//! data in a Storage_Data object, you just provide
//! the persistent object and optionally its name to the function AddRoot.
class Storage_Root : public MMgt_TShared
{

public:

  
  Standard_EXPORT Storage_Root();
  
  Standard_EXPORT Storage_Root(const TCollection_AsciiString& aName, const Handle(Standard_Persistent)& anObject);
  
  Standard_EXPORT   void SetName (const TCollection_AsciiString& aName) ;
  

  //! Returns the name of this root object.
  //! The name may have been given explicitly when
  //! the root was inserted into the Storage_Data
  //! object. If not, the name is a reference number
  //! which was assigned automatically by the driver
  //! when writing the set of data into the container.
  //! When naming the roots, it is easier to retrieve
  //! objects by significant references rather than by
  //! references without any semantic values.
  //! Warning
  //! The returned string will be empty if you call this
  //! function before having named this root object,
  //! either explicitly, or when writing the set of data
  //! into the container.
  Standard_EXPORT   TCollection_AsciiString Name()  const;
  
  Standard_EXPORT   void SetObject (const Handle(Standard_Persistent)& anObject) ;
  

  //! Returns the persistent object encapsulated by this root.
  Standard_EXPORT   Handle(Standard_Persistent) Object()  const;
  
  //! Returns the name of this root type.
  Standard_EXPORT   TCollection_AsciiString Type()  const;


friend class Storage_Schema;


  DEFINE_STANDARD_RTTI(Storage_Root)

protected:




private: 

  
  Standard_EXPORT   void SetReference (const Standard_Integer aRef) ;
  
  Standard_EXPORT   Standard_Integer Reference()  const;
  
  Standard_EXPORT   void SetType (const TCollection_AsciiString& aType) ;

  TCollection_AsciiString myName;
  TCollection_AsciiString myType;
  Handle(Standard_Persistent) myObject;
  Standard_Integer myRef;


};







#endif // _Storage_Root_HeaderFile
