// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDF_ChildIDIterator_HeaderFile
#define _TDF_ChildIDIterator_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_GUID.hxx>
#include <TDF_ChildIterator.hxx>
#include <Handle_TDF_Attribute.hxx>
#include <Standard_Boolean.hxx>
class TDF_Attribute;
class TDF_Label;
class Standard_GUID;


//! Iterates on the children of a label, to find
//! attributes having ID as Attribute ID.
//!
//! Level option works as TDF_ChildIterator.
class TDF_ChildIDIterator 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates an empty iterator.
  Standard_EXPORT TDF_ChildIDIterator();
  
  //! Iterates on the children of the given label. If
  //! <allLevels> option is set to true, it explores not
  //! only the first, but all the sub label levels.
  Standard_EXPORT TDF_ChildIDIterator(const TDF_Label& aLabel, const Standard_GUID& anID, const Standard_Boolean allLevels = Standard_False);
  
  //! Initializes the iteration on the children of the
  //! given label. If <allLevels> option is set to true,
  //! it explores not only the first, but all the sub
  //! label levels.
  Standard_EXPORT   void Initialize (const TDF_Label& aLabel, const Standard_GUID& anID, const Standard_Boolean allLevels = Standard_False) ;
  
  //! Returns True if there is a current Item in the
  //! iteration.
      Standard_Boolean More()  const;
  
  //! Move to the next Item
  Standard_EXPORT   void Next() ;
  
  //! Move to the next Brother. If there is none, go up
  //! etc. This method is interesting only with
  //! "allLevels" behavior, because it avoids to explore
  //! the current label children.
  Standard_EXPORT   void NextBrother() ;
  
  //! Returns the current item; a null handle if there is none.
      Handle(TDF_Attribute) Value()  const;




protected:





private:



  Standard_GUID myID;
  TDF_ChildIterator myItr;
  Handle(TDF_Attribute) myAtt;


};


#include <TDF_ChildIDIterator.lxx>





#endif // _TDF_ChildIDIterator_HeaderFile
