# 1 "json_lexer.mll"
 
  open Printf
  open Lexing

  open Json_type
  open Json_parser

  let loc lexbuf = (lexbuf.lex_start_p, lexbuf.lex_curr_p)

  (* Detection of the encoding from the 4 first characters of the data *)
  let detect_encoding c1 c2 c3 c4 =
    match c1, c2, c3, c4 with
	'\000', '\000', '\000', _ -> `UTF32BE 
      | '\000', _, '\000', _ -> `UTF16BE
      | _, '\000', '\000', '\000' -> `UTF32LE 
      | _, '\000', _, '\000' -> `UTF16LE 
      | _ -> `UTF8

  let hexval c =
    match c with
	'0'..'9' -> int_of_char c - int_of_char '0'
      | 'a'..'f' -> int_of_char c - int_of_char 'a' + 10
      | 'A'..'F' -> int_of_char c - int_of_char 'A' + 10
      | _ -> assert false

  let make_int big_int_mode s =
    try INT (int_of_string s)
    with _ -> 
      if big_int_mode then STRING s
      else json_error (s ^ " is too large for OCaml's type int, sorry")

  let utf8_of_point i =
    Netconversion2.ustring_of_uchar `Enc_utf8 i

  let custom_error descr lexbuf =
    json_error 
      (sprintf "%s:\n%s"
	 (string_of_loc (loc lexbuf))
         descr)

  let lexer_error descr lexbuf =
    custom_error 
      (sprintf "%s '%s'" descr (Lexing.lexeme lexbuf))
      lexbuf

  let set_file_name lexbuf name =
    lexbuf.lex_curr_p <- { lexbuf.lex_curr_p with pos_fname = name }

  let newline lexbuf =
    let pos = lexbuf.lex_curr_p in
    lexbuf.lex_curr_p <- { pos with
			     pos_lnum = pos.pos_lnum + 1;
			     pos_bol = pos.pos_cnum }

  type param = {
    allow_comments : bool;
    big_int_mode : bool;
    allow_nan : bool
  }

# 63 "json_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\235\255\236\255\003\000\238\255\000\000\031\000\241\255\
    \085\000\001\000\000\000\000\000\001\000\000\000\248\255\249\255\
    \250\255\251\255\252\255\253\255\017\000\254\255\001\000\001\000\
    \002\000\247\255\000\000\000\000\003\000\246\255\001\000\004\000\
    \245\255\011\000\244\255\003\000\001\000\003\000\002\000\003\000\
    \000\000\243\255\010\000\020\000\019\000\016\000\022\000\012\000\
    \008\000\242\255\100\000\111\000\121\000\143\000\153\000\163\000\
    \175\000\185\000\002\001\251\255\252\255\037\001\254\255\255\255\
    \035\001\248\255\056\001\250\255\251\255\252\255\253\255\254\255\
    \255\255\111\001\134\001\172\001\249\255\089\000\252\255\253\255\
    \254\255\013\000\255\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\018\000\255\255\015\000\015\000\255\255\
    \020\000\020\000\020\000\020\000\020\000\020\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\020\000\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\016\000\255\255\016\000\255\255\
    \016\000\255\255\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\007\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\003\000\255\255";
  Lexing.lex_default = 
   "\001\000\000\000\000\000\255\255\000\000\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\022\000\255\255\
    \255\255\000\000\255\255\255\255\255\255\000\000\255\255\255\255\
    \000\000\255\255\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\061\000\000\000\000\000\061\000\000\000\000\000\
    \065\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\255\255\255\255\000\000\078\000\000\000\000\000\
    \000\000\255\255\000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\003\000\004\000\255\255\003\000\003\000\000\000\000\000\
    \003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \003\000\000\000\007\000\003\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\008\000\051\000\020\000\
    \005\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\014\000\021\000\082\000\000\000\000\000\000\000\
    \022\000\000\000\000\000\000\000\000\000\050\000\000\000\000\000\
    \000\000\009\000\000\000\000\000\000\000\051\000\010\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\034\000\000\000\017\000\000\000\016\000\000\000\000\000\
    \000\000\033\000\026\000\079\000\050\000\050\000\012\000\025\000\
    \029\000\036\000\037\000\039\000\027\000\031\000\011\000\035\000\
    \032\000\038\000\023\000\028\000\013\000\030\000\024\000\040\000\
    \043\000\041\000\044\000\019\000\045\000\018\000\046\000\047\000\
    \048\000\049\000\000\000\081\000\050\000\005\000\006\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\057\000\
    \000\000\057\000\000\000\000\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\042\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\055\000\000\000\055\000\000\000\053\000\054\000\
    \054\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
    \054\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
    \054\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
    \054\000\054\000\054\000\054\000\054\000\000\000\053\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\056\000\056\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \002\000\255\255\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\000\000\000\000\063\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\072\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\072\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\080\000\000\000\000\000\000\000\000\000\062\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \073\000\073\000\073\000\073\000\073\000\073\000\073\000\073\000\
    \073\000\073\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\073\000\073\000\073\000\073\000\073\000\073\000\072\000\
    \000\000\255\255\000\000\000\000\000\000\071\000\000\000\000\000\
    \000\000\070\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\069\000\000\000\000\000\000\000\068\000\000\000\067\000\
    \066\000\073\000\073\000\073\000\073\000\073\000\073\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\075\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\000\000\000\000\000\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\076\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\000\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\059\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\022\000\003\000\000\000\255\255\255\255\
    \003\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\003\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\000\000\005\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\020\000\081\000\255\255\255\255\255\255\
    \020\000\255\255\255\255\255\255\255\255\005\000\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\006\000\000\000\006\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\033\000\255\255\000\000\255\255\000\000\255\255\255\255\
    \255\255\010\000\012\000\077\000\006\000\005\000\000\000\024\000\
    \028\000\035\000\036\000\038\000\026\000\030\000\000\000\009\000\
    \031\000\037\000\013\000\027\000\000\000\011\000\023\000\039\000\
    \042\000\040\000\043\000\000\000\044\000\000\000\045\000\046\000\
    \047\000\048\000\255\255\077\000\006\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\050\000\
    \255\255\050\000\255\255\255\255\050\000\050\000\050\000\050\000\
    \050\000\050\000\050\000\050\000\050\000\050\000\008\000\051\000\
    \051\000\051\000\051\000\051\000\051\000\051\000\051\000\051\000\
    \051\000\052\000\052\000\052\000\052\000\052\000\052\000\052\000\
    \052\000\052\000\052\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\053\000\255\255\053\000\255\255\052\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\054\000\054\000\054\000\054\000\054\000\054\000\054\000\
    \054\000\054\000\054\000\055\000\055\000\055\000\055\000\055\000\
    \055\000\055\000\055\000\055\000\055\000\255\255\052\000\056\000\
    \056\000\056\000\056\000\056\000\056\000\056\000\056\000\056\000\
    \056\000\057\000\057\000\057\000\057\000\057\000\057\000\057\000\
    \057\000\057\000\057\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\022\000\058\000\058\000\058\000\058\000\058\000\058\000\
    \058\000\058\000\058\000\058\000\058\000\058\000\058\000\058\000\
    \058\000\058\000\058\000\058\000\058\000\058\000\058\000\058\000\
    \058\000\058\000\058\000\058\000\058\000\058\000\058\000\058\000\
    \058\000\058\000\255\255\255\255\058\000\061\000\061\000\061\000\
    \061\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
    \061\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
    \061\000\061\000\061\000\061\000\061\000\061\000\061\000\061\000\
    \061\000\061\000\061\000\061\000\061\000\064\000\255\255\061\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\064\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\077\000\255\255\255\255\255\255\255\255\058\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \066\000\066\000\066\000\066\000\066\000\066\000\066\000\066\000\
    \066\000\066\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\066\000\066\000\066\000\066\000\066\000\066\000\064\000\
    \255\255\061\000\255\255\255\255\255\255\064\000\255\255\255\255\
    \255\255\064\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\064\000\255\255\255\255\255\255\064\000\255\255\064\000\
    \064\000\066\000\066\000\066\000\066\000\066\000\066\000\073\000\
    \073\000\073\000\073\000\073\000\073\000\073\000\073\000\073\000\
    \073\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \073\000\073\000\073\000\073\000\073\000\073\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\074\000\
    \074\000\074\000\074\000\074\000\074\000\255\255\255\255\255\255\
    \073\000\073\000\073\000\073\000\073\000\073\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\255\255\074\000\
    \074\000\074\000\074\000\074\000\074\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\058\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\075\000\075\000\075\000\
    \075\000\075\000\075\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\064\000\255\255\061\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec token p lexbuf =
    __ocaml_lex_token_rec p lexbuf 0
and __ocaml_lex_token_rec p lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 79 "json_lexer.mll"
                 ( if p.allow_comments then 
		     token p lexbuf
		   else lexer_error "Comments are not allowed: " lexbuf )
# 298 "json_lexer.ml"

  | 1 ->
# 82 "json_lexer.mll"
                 ( if p.allow_comments then 
		     (comment lexbuf; 
		      token p lexbuf)
		   else lexer_error "Comments are not allowed: " lexbuf )
# 306 "json_lexer.ml"

  | 2 ->
# 86 "json_lexer.mll"
            ( OBJSTART )
# 311 "json_lexer.ml"

  | 3 ->
# 87 "json_lexer.mll"
            ( OBJEND )
# 316 "json_lexer.ml"

  | 4 ->
# 88 "json_lexer.mll"
            ( ARSTART )
# 321 "json_lexer.ml"

  | 5 ->
# 89 "json_lexer.mll"
            ( AREND )
# 326 "json_lexer.ml"

  | 6 ->
# 90 "json_lexer.mll"
            ( COMMA )
# 331 "json_lexer.ml"

  | 7 ->
# 91 "json_lexer.mll"
            ( COLON )
# 336 "json_lexer.ml"

  | 8 ->
# 92 "json_lexer.mll"
            ( BOOL true )
# 341 "json_lexer.ml"

  | 9 ->
# 93 "json_lexer.mll"
            ( BOOL false )
# 346 "json_lexer.ml"

  | 10 ->
# 94 "json_lexer.mll"
            ( NULL )
# 351 "json_lexer.ml"

  | 11 ->
# 95 "json_lexer.mll"
            ( if p.allow_nan then FLOAT nan
	      else lexer_error "NaN values are not allowed: " lexbuf )
# 357 "json_lexer.ml"

  | 12 ->
# 97 "json_lexer.mll"
               ( if p.allow_nan then FLOAT infinity
		 else lexer_error "Infinite values are not allowed: " lexbuf )
# 363 "json_lexer.ml"

  | 13 ->
# 99 "json_lexer.mll"
                ( if p.allow_nan then FLOAT neg_infinity
		  else lexer_error "Infinite values are not allowed: " lexbuf )
# 369 "json_lexer.ml"

  | 14 ->
# 101 "json_lexer.mll"
            ( STRING (string [] lexbuf) )
# 374 "json_lexer.ml"

  | 15 ->
# 102 "json_lexer.mll"
            ( make_int p.big_int_mode (lexeme lexbuf) )
# 379 "json_lexer.ml"

  | 16 ->
# 103 "json_lexer.mll"
            ( FLOAT (float_of_string (lexeme lexbuf)) )
# 384 "json_lexer.ml"

  | 17 ->
# 104 "json_lexer.mll"
            ( newline lexbuf; token p lexbuf )
# 389 "json_lexer.ml"

  | 18 ->
# 105 "json_lexer.mll"
            ( token p lexbuf )
# 394 "json_lexer.ml"

  | 19 ->
# 106 "json_lexer.mll"
            ( EOF )
# 399 "json_lexer.ml"

  | 20 ->
# 107 "json_lexer.mll"
            ( lexer_error "Invalid token" lexbuf )
# 404 "json_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec p lexbuf __ocaml_lex_state

and string l lexbuf =
    __ocaml_lex_string_rec l lexbuf 58
and __ocaml_lex_string_rec l lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 111 "json_lexer.mll"
                ( String.concat "" (List.rev l) )
# 415 "json_lexer.ml"

  | 1 ->
# 112 "json_lexer.mll"
                ( let s = escaped_char lexbuf in
		    string (s :: l) lexbuf )
# 421 "json_lexer.ml"

  | 2 ->
# 114 "json_lexer.mll"
                ( let s = lexeme lexbuf in
		       string (s :: l) lexbuf )
# 427 "json_lexer.ml"

  | 3 ->
let
# 116 "json_lexer.mll"
         c
# 433 "json_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 116 "json_lexer.mll"
                ( custom_error 
		    (sprintf "Unescaped control character \\u%04X or \
                              unterminated string" (int_of_char c))
		    lexbuf )
# 440 "json_lexer.ml"

  | 4 ->
# 120 "json_lexer.mll"
                ( custom_error "Unterminated string" lexbuf )
# 445 "json_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_rec l lexbuf __ocaml_lex_state

and escaped_char lexbuf =
    __ocaml_lex_escaped_char_rec lexbuf 64
and __ocaml_lex_escaped_char_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 126 "json_lexer.mll"
         ( lexeme lexbuf )
# 456 "json_lexer.ml"

  | 1 ->
# 127 "json_lexer.mll"
         ( "\b" )
# 461 "json_lexer.ml"

  | 2 ->
# 128 "json_lexer.mll"
         ( "\012" )
# 466 "json_lexer.ml"

  | 3 ->
# 129 "json_lexer.mll"
         ( "\n" )
# 471 "json_lexer.ml"

  | 4 ->
# 130 "json_lexer.mll"
         ( "\r" )
# 476 "json_lexer.ml"

  | 5 ->
# 131 "json_lexer.mll"
         ( "\t" )
# 481 "json_lexer.ml"

  | 6 ->
let
# 132 "json_lexer.mll"
                            x
# 487 "json_lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_start_pos + 5) in
# 132 "json_lexer.mll"
                               ( let i = 0x1000 * hexval x.[0] +
					 0x100 * hexval x.[1] +
					 0x10 * hexval x.[2] + 
					 hexval x.[3] in
				 utf8_of_point i )
# 495 "json_lexer.ml"

  | 7 ->
# 137 "json_lexer.mll"
       ( lexer_error "Invalid escape sequence" lexbuf )
# 500 "json_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_escaped_char_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 77
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 140 "json_lexer.mll"
         ( () )
# 511 "json_lexer.ml"

  | 1 ->
# 141 "json_lexer.mll"
         ( lexer_error "Unterminated comment" lexbuf )
# 516 "json_lexer.ml"

  | 2 ->
# 142 "json_lexer.mll"
         ( newline lexbuf; comment lexbuf )
# 521 "json_lexer.ml"

  | 3 ->
# 143 "json_lexer.mll"
         ( comment lexbuf )
# 526 "json_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

;;

# 145 "json_lexer.mll"
 
  let make_param 
      ?(allow_comments = false)
      ?(allow_nan = false)
      ?(big_int_mode = false)
      () =
    { allow_comments = allow_comments;
      big_int_mode = big_int_mode;
      allow_nan = allow_nan }

# 543 "json_lexer.ml"
