/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class AccessMethodMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private Method invokingMethod;

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.invokingMethod = method;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedClassAccept(this);
        stringConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.bootstrapMethodHandleAccept(clazz, this);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        clazz.constantPoolEntryAccept(methodHandleConstant.u2referenceIndex, this);
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
        refConstant.referencedClassAccept(this);
        refConstant.referencedMemberAccept(this);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        int n = clazz.getAccessFlags();
        if ((n & 1) == 0) {
            AccessMethodMarker.setAccessesPackageCode(this.invokingMethod);
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        int n = member.getAccessFlags();
        if ((n & 2) != 0) {
            AccessMethodMarker.setAccessesPrivateCode(this.invokingMethod);
        } else if ((n & 4) != 0) {
            AccessMethodMarker.setAccessesProtectedCode(this.invokingMethod);
        } else if ((n & 1) == 0) {
            AccessMethodMarker.setAccessesPackageCode(this.invokingMethod);
        }
    }

    private static void setAccessesPrivateCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setAccessesPrivateCode();
        }
    }

    public static boolean accessesPrivateCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.accessesPrivateCode();
    }

    private static void setAccessesPackageCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setAccessesPackageCode();
        }
    }

    public static boolean accessesPackageCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.accessesPackageCode();
    }

    private static void setAccessesProtectedCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setAccessesProtectedCode();
        }
    }

    public static boolean accessesProtectedCode(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.accessesProtectedCode();
    }
}

