/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class InterfaceUsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final UsageMarker usageMarker;
    private boolean used;
    private boolean anyUsed;

    public InterfaceUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        boolean bl = this.usageMarker.isUsed(programClass);
        boolean bl2 = this.usageMarker.isPossiblyUsed(programClass);
        if (bl || bl2) {
            boolean bl3 = this.anyUsed;
            this.anyUsed = false;
            programClass.interfaceConstantsAccept(this);
            bl |= this.anyUsed;
            this.anyUsed = bl3;
            if (bl2) {
                if (bl) {
                    this.usageMarker.markAsUsed(programClass);
                    programClass.thisClassConstantAccept(this);
                    programClass.superClassConstantAccept(this);
                } else {
                    this.usageMarker.markAsUnused(programClass);
                }
            }
        }
        this.used = bl;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.used = true;
        this.anyUsed = true;
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        boolean bl = this.usageMarker.isUsed(classConstant);
        if (!bl) {
            classConstant.referencedClassAccept(this);
            bl = this.used;
            if (bl) {
                this.usageMarker.markAsUsed(classConstant);
                clazz.constantPoolEntryAccept(classConstant.u2nameIndex, this);
            }
        }
        this.used = bl;
        this.anyUsed |= bl;
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (!this.usageMarker.isUsed(utf8Constant)) {
            this.usageMarker.markAsUsed(utf8Constant);
        }
    }
}

