/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.library;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.protege.editor.core.util.ProtegeDirectories;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.model.library.CatalogEntryManagerLoader;
import org.protege.editor.owl.model.library.CatalogEntryManagerPlugin;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyCatalogManager {
    public static final String CATALOG_NAME = "catalog-v001.xml";
    public static final String CATALOG_BACKUP_PREFIX = "catalog-backup-";
    public static final String TIMESTAMP = "Timestamp";
    private Map<File, XMLCatalog> localCatalogs = new HashMap<File, XMLCatalog>();
    private XMLCatalog activeCatalog;
    private File activeCatalogFolder;
    private List<CatalogEntryManager> entryManagers;
    private Logger logger = LoggerFactory.getLogger(OntologyCatalogManager.class);

    private static void backup(File folder, File catalogFile) {
        File backup;
        int i = 0;
        while ((backup = new File(folder, CATALOG_BACKUP_PREFIX + i++ + ".xml")).exists()) {
        }
        catalogFile.renameTo(backup);
    }

    public static File getCatalogFile(File folder) {
        return new File(folder, CATALOG_NAME);
    }

    public static File getCatalogFile(XMLCatalog catalog) {
        if (catalog == null || catalog.getXmlBaseContext() == null) {
            return null;
        }
        File f = new File(catalog.getXmlBaseContext().getXmlBase());
        if (f.exists() && f.isDirectory()) {
            f = OntologyCatalogManager.getCatalogFile(f);
        }
        return f.exists() ? f : null;
    }

    public static File getGlobalCatalogFile() {
        return OntologyCatalogManager.getCatalogFile(ProtegeDirectories.getDataDirectory());
    }

    public OntologyCatalogManager() {
        this.entryManagers = new ArrayList<CatalogEntryManager>();
        CatalogEntryManagerLoader pluginLoader = new CatalogEntryManagerLoader();
        for (CatalogEntryManagerPlugin plugin : pluginLoader.getPlugins()) {
            try {
                this.entryManagers.add(plugin.newInstance());
            }
            catch (Throwable t) {
                this.logger.warn("An error occurred whilst instantiating a CatalogEntryManager plugin: {}", t);
            }
        }
    }

    public OntologyCatalogManager(List<? extends CatalogEntryManager> entryManagers) {
        this.entryManagers = new ArrayList<CatalogEntryManager>(entryManagers);
    }

    public List<CatalogEntryManager> getCatalogEntryManagers() {
        return Collections.unmodifiableList(this.entryManagers);
    }

    public XMLCatalog ensureCatalogExists(File folder) {
        XMLCatalog catalog = null;
        File catalogFile = OntologyCatalogManager.getCatalogFile(folder);
        boolean alreadyExists = catalogFile.exists();
        boolean modified = false;
        if (alreadyExists) {
            try {
                catalog = CatalogUtilities.parseDocument((URL)catalogFile.toURI().toURL());
            }
            catch (Throwable e) {
                this.logger.warn("An error occurred whilst parsing the catalog document at {}.  Error: {}", (Object)catalogFile.getAbsolutePath(), (Object)e);
                OntologyCatalogManager.backup(folder, catalogFile);
            }
        }
        if (catalog == null) {
            catalog = new XMLCatalog(folder.toURI());
            modified = true;
        }
        if (alreadyExists) {
            try {
                modified |= this.update(catalog);
            }
            catch (Throwable t) {
                this.logger.warn("An error occurred whilst updating the catalog document at {}.  Error: {}", (Object)catalogFile.getAbsolutePath(), (Object)t);
            }
        } else {
            for (CatalogEntryManager entryManager : this.entryManagers) {
                try {
                    modified |= entryManager.initializeCatalog(folder, catalog);
                }
                catch (Throwable t) {
                    this.logger.warn("An error occurred whilst initializing the catalog at {}.  Error: {}", (Object)catalogFile.getAbsolutePath(), (Object)t);
                }
            }
        }
        if (modified) {
            try {
                CatalogUtilities.save((XMLCatalog)catalog, (File)catalogFile);
            }
            catch (IOException e) {
                this.logger.warn("An error occurred whilst saving the catalog at {}.  Error: {}", (Object)catalogFile.getAbsolutePath(), (Object)e);
            }
        }
        return catalog;
    }

    public URI getRedirect(URI original) {
        XMLCatalog catalog;
        URI redirect = null;
        Iterator<XMLCatalog> iterator = this.getAllCatalogs().iterator();
        while (iterator.hasNext() && (redirect = CatalogUtilities.getRedirect((URI)original, (XMLCatalog)(catalog = iterator.next()))) == null) {
        }
        return redirect;
    }

    public boolean update(XMLCatalog catalog) throws IOException {
        boolean modified = false;
        for (Entry entry : catalog.getEntries()) {
            for (CatalogEntryManager updater : this.entryManagers) {
                if (!updater.isSuitable(entry)) continue;
                modified |= updater.update(entry);
            }
        }
        return modified;
    }

    public Collection<XMLCatalog> getLocalCatalogs() {
        return this.localCatalogs.values();
    }

    public List<XMLCatalog> getAllCatalogs() {
        ArrayList<XMLCatalog> catalogs = new ArrayList<XMLCatalog>();
        catalogs.addAll(this.getLocalCatalogs());
        return catalogs;
    }

    public XMLCatalog getActiveCatalog() {
        return this.activeCatalog;
    }

    public File getActiveCatalogFolder() {
        return this.activeCatalogFolder;
    }

    public XMLCatalog addFolder(File dir) {
        XMLCatalog lib = this.localCatalogs.get(dir);
        if (lib == null) {
            lib = this.ensureCatalogExists(dir);
            this.localCatalogs.put(dir, lib);
        }
        this.activeCatalog = lib;
        this.activeCatalogFolder = dir;
        return lib;
    }

    public void reloadFolder(File dir) throws IOException {
        this.localCatalogs.remove(dir);
        this.localCatalogs.put(dir, CatalogUtilities.parseDocument((URL)OntologyCatalogManager.getCatalogFile(dir).toURI().toURL()));
        this.activeCatalog = this.localCatalogs.get(this.activeCatalogFolder);
    }
}

