/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum OWLFacet implements HasShortForm,
HasIRI,
HasPrefixedName
{
    LENGTH(Namespaces.XSD, "length", "length"),
    MIN_LENGTH(Namespaces.XSD, "minLength", "minLength"),
    MAX_LENGTH(Namespaces.XSD, "maxLength", "maxLength"),
    PATTERN(Namespaces.XSD, "pattern", "pattern"),
    MIN_INCLUSIVE(Namespaces.XSD, "minInclusive", ">="),
    MIN_EXCLUSIVE(Namespaces.XSD, "minExclusive", ">"),
    MAX_INCLUSIVE(Namespaces.XSD, "maxInclusive", "<="),
    MAX_EXCLUSIVE(Namespaces.XSD, "maxExclusive", "<"),
    TOTAL_DIGITS(Namespaces.XSD, "totalDigits", "totalDigits"),
    FRACTION_DIGITS(Namespaces.XSD, "fractionDigits", "fractionDigits"),
    LANG_RANGE(Namespaces.RDF, "langRange", "langRange");

    public static final Set<IRI> FACET_IRIS;
    @Nonnull
    private final IRI iri;
    @Nonnull
    private final String shortForm;
    @Nonnull
    private final String symbolicForm;
    @Nonnull
    private final String prefixedName;

    private OWLFacet(@Nonnull Namespaces ns, String shortForm, String symbolicForm) {
        this.iri = IRI.create(ns.toString(), shortForm);
        this.shortForm = shortForm;
        this.symbolicForm = symbolicForm;
        this.prefixedName = ns.getPrefixName() + ':' + shortForm;
    }

    @Override
    public String getShortForm() {
        return this.shortForm;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String getSymbolicForm() {
        return this.symbolicForm;
    }

    public String toString() {
        return this.getShortForm();
    }

    public static Set<IRI> getFacetIRIs() {
        return FACET_IRIS;
    }

    @Nonnull
    public static OWLFacet getFacet(@Nonnull IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getIRI().equals(iri)) continue;
            return vocabulary;
        }
        throw new IllegalArgumentException("Unknown facet: " + iri);
    }

    public static OWLFacet getFacetByShortName(@Nonnull String shortName) {
        OWLAPIPreconditions.checkNotNull(shortName);
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getShortForm().equals(shortName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static OWLFacet getFacetBySymbolicName(String symbolicName) {
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getSymbolicForm().equals(symbolicName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static Set<String> getFacets() {
        HashSet<String> result = new HashSet<String>();
        for (OWLFacet v : OWLFacet.values()) {
            result.add(v.getSymbolicForm());
        }
        return result;
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }

    static {
        HashSet<IRI> iris = new HashSet<IRI>();
        for (OWLFacet v : OWLFacet.values()) {
            iris.add(v.getIRI());
        }
        FACET_IRIS = Collections.unmodifiableSet(iris);
    }
}

