/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ZipUtil");

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        return ZipUtil.addFileToZip(zos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            InputStream is = contentProcessor.getContent(file);
            try {
                FileUtil.copy(is, zos);
            }
            finally {
                is.close();
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (jarOutputStream == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        ZipUtil.addFileToZip(jarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
        return true;
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (outputStream == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (jarFile != null && FileUtil.isAncestor(dir, jarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        ZipUtil.extract(file, outputDir, filenameFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        if (file == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipUtil.extract(zipFile, outputDir, filenameFilter, overwrite);
        }
        finally {
            zipFile.close();
        }
    }

    public static void extract(@NotNull ZipFile zipFile, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        ZipUtil.extract(zipFile, outputDir, filenameFilter, true);
    }

    public static void extract(@NotNull ZipFile zipFile, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(19);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(20);
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(outputDir, entry.getName());
            if (filenameFilter != null && !filenameFilter.accept(file.getParentFile(), file.getName())) continue;
            ZipUtil.extractEntry(entry, zipFile.getInputStream(entry), outputDir, overwrite);
        }
    }

    public static void extractEntry(ZipEntry entry, InputStream inputStream, File outputDir) throws IOException {
        ZipUtil.extractEntry(entry, inputStream, outputDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractEntry(ZipEntry entry, InputStream inputStream, File outputDir, boolean overwrite) throws IOException {
        boolean isDirectory = entry.isDirectory();
        String relativeName = entry.getName();
        File file = new File(outputDir, relativeName);
        if (file.exists() && !overwrite) {
            return;
        }
        FileUtil.createParentDirs(file);
        if (isDirectory) {
            file.mkdir();
        } else {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                FileUtil.copy(is, os);
            }
            finally {
                os.close();
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsFolder(File zip) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZipContainsEntry(File zip, String relativePath) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (!relativePath.equals(zipEntry.getName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, OutputStream out, Map<String, File> relpathToFile) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipOutputStream zos = new ZipOutputStream(out);
        try {
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                String name = e.getName();
                if (!relpathToFile.containsKey(name)) {
                    ZipEntry e2 = new ZipEntry(name);
                    e2.setMethod(e.getMethod());
                    e2.setTime(e.getTime());
                    e2.setComment(e.getComment());
                    e2.setExtra(e.getExtra());
                    if (e.getMethod() == 0) {
                        e2.setSize(e.getSize());
                        e2.setCrc(e.getCrc());
                    }
                    zos.putNextEntry(e2);
                    FileUtil.copy(zis, zos);
                    continue;
                }
                File file = relpathToFile.get(name);
                relpathToFile.remove(name);
                ZipUtil.addFileToZip(zos, file, name, null, null);
            }
            for (String path : relpathToFile.keySet()) {
                File file = relpathToFile.get(path);
                ZipUtil.addFileToZip(zos, file, path, null, null);
            }
        }
        finally {
            zis.close();
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static File compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(21);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(22);
        }
        FileInputStream is = new FileInputStream(srcFile);
        try {
            File file;
            ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));
            try {
                os.putNextEntry(new ZipEntry(srcFile.getName()));
                FileUtilRt.copy(is, os);
                os.closeEntry();
                file = zipFile;
            }
            catch (Throwable throwable) {
                os.close();
                throw throwable;
            }
            os.close();
            return file;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zos";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOutputStream";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ZipUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileToZip";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileOrDirRecursively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirToZipRecursively";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "compressFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

