/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.traversal;

import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class DOMNodeIterator
implements NodeIterator {
    protected static final short INITIAL = 0;
    protected static final short INVALID = 1;
    protected static final short FORWARD = 2;
    protected static final short BACKWARD = 3;
    protected AbstractDocument document;
    protected Node root;
    protected int whatToShow;
    protected NodeFilter filter;
    protected boolean expandEntityReferences;
    protected short state;
    protected Node referenceNode;

    public DOMNodeIterator(AbstractDocument abstractDocument, Node node, int n, NodeFilter nodeFilter, boolean bl) {
        this.document = abstractDocument;
        this.root = node;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.expandEntityReferences = bl;
        this.referenceNode = this.root;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    @Override
    public Node nextNode() {
        switch (this.state) {
            case 1: {
                throw this.document.createDOMException((short)11, "detached.iterator", null);
            }
            case 0: 
            case 3: {
                this.state = (short)2;
                return this.referenceNode;
            }
        }
        do {
            this.unfilteredNextNode();
            if (this.referenceNode != null) continue;
            return null;
        } while ((this.whatToShow & 1 << this.referenceNode.getNodeType() - 1) == 0 || this.filter != null && this.filter.acceptNode(this.referenceNode) != 1);
        return this.referenceNode;
    }

    @Override
    public Node previousNode() {
        switch (this.state) {
            case 1: {
                throw this.document.createDOMException((short)11, "detached.iterator", null);
            }
            case 0: 
            case 2: {
                this.state = (short)3;
                return this.referenceNode;
            }
        }
        do {
            this.unfilteredPreviousNode();
            if (this.referenceNode != null) continue;
            return this.referenceNode;
        } while ((this.whatToShow & 1 << this.referenceNode.getNodeType() - 1) == 0 || this.filter != null && this.filter.acceptNode(this.referenceNode) != 1);
        return this.referenceNode;
    }

    @Override
    public void detach() {
        this.state = 1;
        this.document.detachNodeIterator(this);
    }

    public void nodeToBeRemoved(Node node) {
        Node node2;
        if (this.state == 1) {
            return;
        }
        for (node2 = this.referenceNode; node2 != null && node2 != this.root && node2 != node; node2 = node2.getParentNode()) {
        }
        if (node2 == null || node2 == this.root) {
            return;
        }
        if (this.state == 3) {
            Node node3;
            if ((node2.getNodeType() != 5 || this.expandEntityReferences) && (node3 = node2.getFirstChild()) != null) {
                this.referenceNode = node3;
                return;
            }
            node3 = node2.getNextSibling();
            if (node3 != null) {
                this.referenceNode = node3;
                return;
            }
            node3 = node2;
            while ((node3 = node3.getParentNode()) != null && node3 != this.root) {
                Node node4 = node3.getNextSibling();
                if (node4 == null) continue;
                this.referenceNode = node4;
                return;
            }
            this.referenceNode = null;
        } else {
            Node node5 = node2.getPreviousSibling();
            if (node5 == null) {
                this.referenceNode = node2.getParentNode();
                return;
            }
            if (node5.getNodeType() != 5 || this.expandEntityReferences) {
                Node node6;
                while ((node6 = node5.getLastChild()) != null) {
                    node5 = node6;
                }
            }
            this.referenceNode = node5;
        }
    }

    protected void unfilteredNextNode() {
        Node node;
        if (this.referenceNode == null) {
            return;
        }
        if ((this.referenceNode.getNodeType() != 5 || this.expandEntityReferences) && (node = this.referenceNode.getFirstChild()) != null) {
            this.referenceNode = node;
            return;
        }
        node = this.referenceNode.getNextSibling();
        if (node != null) {
            this.referenceNode = node;
            return;
        }
        node = this.referenceNode;
        while ((node = node.getParentNode()) != null && node != this.root) {
            Node node2 = node.getNextSibling();
            if (node2 == null) continue;
            this.referenceNode = node2;
            return;
        }
        this.referenceNode = null;
    }

    protected void unfilteredPreviousNode() {
        if (this.referenceNode == null) {
            return;
        }
        if (this.referenceNode == this.root) {
            this.referenceNode = null;
            return;
        }
        Node node = this.referenceNode.getPreviousSibling();
        if (node == null) {
            this.referenceNode = this.referenceNode.getParentNode();
            return;
        }
        if (node.getNodeType() != 5 || this.expandEntityReferences) {
            Node node2;
            while ((node2 = node.getLastChild()) != null) {
                node = node2;
            }
        }
        this.referenceNode = node;
    }
}

