/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;

public class TableDirectory {
    private int version = 0;
    private short numTables = 0;
    private short searchRange = 0;
    private short entrySelector = 0;
    private short rangeShift = 0;
    private DirectoryEntry[] entries;

    public TableDirectory(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        this.version = randomAccessFile.readInt();
        this.numTables = randomAccessFile.readShort();
        this.searchRange = randomAccessFile.readShort();
        this.entrySelector = randomAccessFile.readShort();
        this.rangeShift = randomAccessFile.readShort();
        this.entries = new DirectoryEntry[this.numTables];
        for (n = 0; n < this.numTables; ++n) {
            this.entries[n] = new DirectoryEntry(randomAccessFile);
        }
        n = 1;
        while (n != 0) {
            n = 0;
            for (int i = 0; i < this.numTables - 1; ++i) {
                if (this.entries[i].getOffset() <= this.entries[i + 1].getOffset()) continue;
                DirectoryEntry directoryEntry = this.entries[i];
                this.entries[i] = this.entries[i + 1];
                this.entries[i + 1] = directoryEntry;
                n = 1;
            }
        }
    }

    public DirectoryEntry getEntry(int n) {
        return this.entries[n];
    }

    public DirectoryEntry getEntryByTag(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.entries[i].getTag() != n) continue;
            return this.entries[i];
        }
        return null;
    }

    public short getEntrySelector() {
        return this.entrySelector;
    }

    public short getNumTables() {
        return this.numTables;
    }

    public short getRangeShift() {
        return this.rangeShift;
    }

    public short getSearchRange() {
        return this.searchRange;
    }

    public int getVersion() {
        return this.version;
    }
}

