/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;

public abstract class RepeatSvnActionThroughBusy {
    public static final int REPEAT = 10;
    public static final Processor<Exception> ourBusyExceptionProcessor = e -> {
        if (e instanceof SVNException) {
            Throwable cause;
            SVNErrorCode errorCode = ((SVNException)((Object)((Object)e))).getErrorMessage().getErrorCode();
            if (SVNErrorCode.WC_LOCKED.equals((Object)errorCode)) {
                return true;
            }
            if (SVNErrorCode.SQLITE_ERROR.equals((Object)errorCode) && (cause = ((SVNException)((Object)((Object)e))).getErrorMessage().getCause()) instanceof SqlJetException) {
                return SqlJetErrorCode.BUSY.equals((Object)((SqlJetException)cause).getErrorCode());
            }
        }
        return false;
    };
    protected int myCnt = 10;
    protected long myTimeout = 50L;
    protected Object myT;

    protected abstract void executeImpl() throws VcsException;

    public <T> T compute() throws VcsException {
        this.execute();
        return (T)this.myT;
    }

    public void execute() throws VcsException {
        while (true) {
            try {
                this.executeImpl();
            }
            catch (VcsException e) {
                if (ourBusyExceptionProcessor.process((Object)e) && this.myCnt > 0) {
                    TimeoutUtil.sleep((long)(this.myTimeout * (long)(10 - this.myCnt + 1)));
                    --this.myCnt;
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

