/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class SvnBranchConfigurationNew {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew");
    private String myTrunkUrl = "";
    public Map<String, InfoStorage<List<SvnBranchItem>>> myBranchMap = new HashMap<String, InfoStorage<List<SvnBranchItem>>>();
    private boolean myUserinfoInUrl;

    public boolean isUserinfoInUrl() {
        return this.myUserinfoInUrl;
    }

    public void setUserinfoInUrl(boolean userinfoInUrl) {
        this.myUserinfoInUrl = userinfoInUrl;
    }

    public void setTrunkUrl(String trunkUrl) {
        this.myTrunkUrl = trunkUrl;
    }

    public String getTrunkUrl() {
        return this.myTrunkUrl;
    }

    public List<String> getBranchUrls() {
        ArrayList<String> result = new ArrayList<String>(this.myBranchMap.keySet());
        List cutList = ContainerUtil.map(result, SvnBranchConfigurationNew::cutEndSlash);
        Collections.sort(cutList);
        return cutList;
    }

    public void addBranches(String branchParentName, InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchParentName = SvnBranchConfigurationNew.ensureEndSlash(branchParentName));
        if (current != null) {
            LOG.info("Branches list not added for : '" + branchParentName + "; this branch parent URL is already present.");
            return;
        }
        this.myBranchMap.put(branchParentName, items);
    }

    public static String ensureEndSlash(String name) {
        return name.trim().endsWith("/") ? name : name + "/";
    }

    private static String cutEndSlash(String name) {
        return name.endsWith("/") && name.length() > 0 ? name.substring(0, name.length() - 1) : name;
    }

    public void updateBranch(String branchParentName, InfoStorage<List<SvnBranchItem>> items) {
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchParentName = SvnBranchConfigurationNew.ensureEndSlash(branchParentName));
        if (current == null) {
            LOG.info("Branches list not updated for : '" + branchParentName + "; since config has changed.");
            return;
        }
        current.accept(items);
    }

    public Map<String, InfoStorage<List<SvnBranchItem>>> getBranchMap() {
        return this.myBranchMap;
    }

    public List<SvnBranchItem> getBranches(String url) {
        url = SvnBranchConfigurationNew.ensureEndSlash(url);
        return this.myBranchMap.get(url).getValue();
    }

    public SvnBranchConfigurationNew copy() {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.myUserinfoInUrl = this.myUserinfoInUrl;
        result.myTrunkUrl = this.myTrunkUrl;
        result.myBranchMap = new HashMap<String, InfoStorage<List<SvnBranchItem>>>();
        for (Map.Entry<String, InfoStorage<List<SvnBranchItem>>> entry : this.myBranchMap.entrySet()) {
            InfoStorage<List<SvnBranchItem>> infoStorage = entry.getValue();
            result.myBranchMap.put(entry.getKey(), new InfoStorage(new ArrayList(infoStorage.getValue()), infoStorage.getInfoReliability()));
        }
        return result;
    }

    @Nullable
    public String getBaseUrl(String url) {
        if (this.myTrunkUrl != null && SVNPathUtil.isAncestor((String)this.myTrunkUrl, (String)url)) {
            return SvnBranchConfigurationNew.cutEndSlash(this.myTrunkUrl);
        }
        for (String branchUrl : this.myBranchMap.keySet()) {
            if (!SVNPathUtil.isAncestor((String)branchUrl, (String)url)) continue;
            String relativePath = SVNPathUtil.getRelativePath((String)branchUrl, (String)url);
            int secondSlash = relativePath.indexOf("/");
            return SvnBranchConfigurationNew.cutEndSlash(branchUrl + (secondSlash == -1 ? relativePath : relativePath.substring(0, secondSlash)));
        }
        return null;
    }

    @Nullable
    public String getBaseName(String url) {
        String baseUrl = this.getBaseUrl(url);
        if (baseUrl == null) {
            return null;
        }
        int lastSlash = baseUrl.lastIndexOf("/");
        return lastSlash == -1 ? baseUrl : baseUrl.substring(lastSlash + 1);
    }

    @Nullable
    public String getRelativeUrl(String url) {
        String baseUrl = this.getBaseUrl(url);
        return baseUrl == null ? null : url.substring(baseUrl.length());
    }

    @Nullable
    public SVNURL getWorkingBranch(@NotNull SVNURL someUrl) throws SvnBindException {
        String baseUrl;
        if (someUrl == null) {
            SvnBranchConfigurationNew.$$$reportNull$$$0(0);
        }
        return (baseUrl = this.getBaseUrl(someUrl.toString())) == null ? null : SvnUtil.createUrl(baseUrl);
    }

    private void iterateUrls(UrlListener listener) throws SVNException {
        if (listener.accept(this.myTrunkUrl)) {
            return;
        }
        for (String branchUrl : this.myBranchMap.keySet()) {
            List<SvnBranchItem> children = this.myBranchMap.get(branchUrl).getValue();
            for (SvnBranchItem child : children) {
                if (!listener.accept(child.getUrl())) continue;
                return;
            }
        }
    }

    @Nullable
    public Map<String, String> getUrl2FileMappings(Project project, VirtualFile root) {
        try {
            BranchRootSearcher searcher = new BranchRootSearcher(SvnVcs.getInstance(project), root);
            this.iterateUrls(searcher);
            return searcher.getBranchesUnder();
        }
        catch (SVNException e) {
            return null;
        }
    }

    public void removeBranch(String url) {
        url = SvnBranchConfigurationNew.ensureEndSlash(url);
        this.myBranchMap.remove(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "someUrl", "org/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew", "getWorkingBranch"));
    }

    private static interface UrlListener {
        public boolean accept(String var1) throws SVNException;
    }

    private static class BranchRootSearcher
    implements UrlListener {
        private final VirtualFile myRoot;
        private final SVNURL myRootUrl;
        private final Map<String, String> myBranchesUnder;

        private BranchRootSearcher(SvnVcs vcs, VirtualFile root) {
            this.myRoot = root;
            this.myBranchesUnder = new HashMap<String, String>();
            Info info = vcs.getInfo(this.myRoot.getPath());
            this.myRootUrl = info != null ? info.getURL() : null;
        }

        @Override
        public boolean accept(String url) throws SVNException {
            if (this.myRootUrl != null) {
                File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myRoot);
                String baseUrl = this.myRootUrl.getPath();
                SVNURL branchUrl = SVNURL.parseURIEncoded((String)url);
                if (this.myRootUrl.equals((Object)SVNURLUtil.getCommonURLAncestor((SVNURL)this.myRootUrl, (SVNURL)branchUrl))) {
                    File file = SvnUtil.fileFromUrl(baseDir, baseUrl, branchUrl.getPath());
                    this.myBranchesUnder.put(url, file.getAbsolutePath());
                }
            }
            return false;
        }

        public Map<String, String> getBranchesUnder() {
            return this.myBranchesUnder;
        }
    }
}

