/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.browse;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitBrowseClient
extends BaseSvnClient
implements BrowseClient {
    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable Depth depth, @Nullable DirectoryEntryConsumer handler) throws VcsException {
        if (target == null) {
            SvnKitBrowseClient.$$$reportNull$$$0(0);
        }
        this.assertUrl(target);
        SVNLogClient client = this.getLogClient();
        ISVNDirEntryHandler wrappedHandler = SvnKitBrowseClient.wrapHandler(handler);
        client.setIgnoreExternals(true);
        try {
            if (target.isFile()) {
                client.doList(target.getFile(), target.getPegRevision(), SvnKitBrowseClient.notNullize(revision), true, SvnKitBrowseClient.toDepth(depth), -1, wrappedHandler);
            } else {
                client.doList(target.getURL(), target.getPegRevision(), SvnKitBrowseClient.notNullize(revision), true, SvnKitBrowseClient.toDepth(depth), -1, wrappedHandler);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public long createDirectory(@NotNull SvnTarget target, @NotNull String message, boolean makeParents) throws VcsException {
        if (target == null) {
            SvnKitBrowseClient.$$$reportNull$$$0(1);
        }
        if (message == null) {
            SvnKitBrowseClient.$$$reportNull$$$0(2);
        }
        this.assertUrl(target);
        try {
            SVNCommitInfo commitInfo = this.myVcs.getSvnKitManager().createCommitClient().doMkDir(new SVNURL[]{target.getURL()}, message, null, makeParents);
            return commitInfo.getNewRevision();
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @NotNull
    private SVNLogClient getLogClient() {
        SvnAuthenticationManager authManager = this.myIsActive ? this.myVcs.getSvnConfiguration().getInteractiveManager(this.myVcs) : this.myVcs.getSvnConfiguration().getPassiveAuthenticationManager(this.myVcs);
        SVNLogClient sVNLogClient = this.myVcs.getSvnKitManager().createLogClient((ISVNAuthenticationManager)authManager);
        if (sVNLogClient == null) {
            SvnKitBrowseClient.$$$reportNull$$$0(3);
        }
        return sVNLogClient;
    }

    @Nullable
    private static ISVNDirEntryHandler wrapHandler(@Nullable DirectoryEntryConsumer handler) {
        return handler == null ? null : new SkipEmptyNameDirectoriesHandler(handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/browse/SvnKitBrowseClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/browse/SvnKitBrowseClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SkipEmptyNameDirectoriesHandler
    implements ISVNDirEntryHandler {
        @NotNull
        private final DirectoryEntryConsumer handler;

        public SkipEmptyNameDirectoriesHandler(@NotNull DirectoryEntryConsumer handler) {
            if (handler == null) {
                SkipEmptyNameDirectoriesHandler.$$$reportNull$$$0(0);
            }
            this.handler = handler;
        }

        public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
            if (!SkipEmptyNameDirectoriesHandler.isEmptyNameDirectory(dirEntry)) {
                this.handler.consume(DirectoryEntry.create(dirEntry));
            }
        }

        private static boolean isEmptyNameDirectory(@NotNull SVNDirEntry dirEntry) {
            if (dirEntry == null) {
                SkipEmptyNameDirectoriesHandler.$$$reportNull$$$0(1);
            }
            return SVNNodeKind.DIR.equals(dirEntry.getKind()) && StringUtil.isEmpty((String)dirEntry.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirEntry";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/browse/SvnKitBrowseClient$SkipEmptyNameDirectoriesHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmptyNameDirectory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

