/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;

public class ServerSSLDialog
extends DialogWrapper {
    @NotNull
    private final String myCertificateInfo;
    private Action myTempAction;
    private int myResult;
    @NonNls
    public static final String ALGORITHM_SHA1 = "SHA1";

    public ServerSSLDialog(Project project, @NotNull X509Certificate cert, boolean store) {
        if (cert == null) {
            ServerSSLDialog.$$$reportNull$$$0(0);
        }
        this(project, ServerSSLDialog.getServerCertificateInfo(cert), store);
    }

    public ServerSSLDialog(Project project, @NotNull String certificateInfo, boolean store) {
        if (certificateInfo == null) {
            ServerSSLDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myCertificateInfo = certificateInfo;
        this.myResult = 0;
        this.setOKButtonText(SvnBundle.message("button.text.ssl.accept", new Object[0]));
        this.setOKActionEnabled(store);
        this.setCancelButtonText(SvnBundle.message("button.text.ssl.reject", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.ssl.examine.server.crertificate", new Object[0]));
        this.setResizable(true);
        this.init();
    }

    public boolean shouldCloseOnCross() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getTempAction(), this.getCancelAction()};
        if (actionArray == null) {
            ServerSSLDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private Action getTempAction() {
        if (this.myTempAction == null) {
            this.myTempAction = new AbstractAction(SvnBundle.message("server.ssl.accept.temporary.action.name", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSSLDialog.this.myResult = 1;
                    ServerSSLDialog.this.close(0);
                }
            };
        }
        return this.myTempAction;
    }

    protected void doOKAction() {
        this.myResult = 2;
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myResult = 0;
        super.doCancelAction();
    }

    public int getResult() {
        return this.myResult;
    }

    protected String getDimensionServiceKey() {
        return "svn.sslDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)new JLabel(SvnBundle.message("label.ssl.server.provided.certificate", new Object[0])), "North");
        JTextArea area = new JTextArea(5, 50);
        area.setText(this.myCertificateInfo);
        area.setEditable(false);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)area), "Center");
        return panel;
    }

    @NotNull
    private static String getFingerprint(@NotNull X509Certificate cert) {
        if (cert == null) {
            ServerSSLDialog.$$$reportNull$$$0(3);
        }
        byte[] data = null;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        String string = data != null ? SVNSSLUtil.getFingerprint((byte[])data, (String)ALGORITHM_SHA1) : "";
        if (string == null) {
            ServerSSLDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getServerCertificateInfo(@NotNull X509Certificate cert) {
        if (cert == null) {
            ServerSSLDialog.$$$reportNull$$$0(5);
        }
        String string = " - Subject: " + cert.getSubjectDN().getName() + '\n' + " - Valid: " + "from " + cert.getNotBefore() + " until " + cert.getNotAfter() + '\n' + " - Issuer: " + cert.getIssuerDN().getName() + '\n' + " - Fingerprint: " + ServerSSLDialog.getFingerprint(cert);
        if (string == null) {
            ServerSSLDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cert";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificateInfo";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/ServerSSLDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/ServerSSLDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFingerprint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerCertificateInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFingerprint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServerCertificateInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

