/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class PointMerger
extends Merger {
    @NotNull
    private final List<Change> mySelectedChanges;

    public PointMerger(SvnVcs vcs, CommittedChangeList selectedChangeList, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, @NotNull List<Change> selectedChanges, String branchName) {
        if (selectedChanges == null) {
            PointMerger.$$$reportNull$$$0(0);
        }
        super(vcs, ContainerUtil.newArrayList((Object[])new CommittedChangeList[]{selectedChangeList}), target, handler, currentBranchUrl, branchName);
        this.mySelectedChanges = ContainerUtil.sorted(selectedChanges, (Comparator)ChangesComparator.getInstance());
    }

    @Override
    protected void doMerge() throws VcsException {
        for (Change change : this.mySelectedChanges) {
            SvnRepositoryContentRevision before = (SvnRepositoryContentRevision)change.getBeforeRevision();
            SvnRepositoryContentRevision after = (SvnRepositoryContentRevision)change.getAfterRevision();
            if (before == null) {
                this.add(after);
                continue;
            }
            if (after == null) {
                this.delete(before);
                continue;
            }
            this.merge(before, after);
        }
    }

    private void merge(@NotNull SvnRepositoryContentRevision before, @NotNull SvnRepositoryContentRevision after) throws VcsException {
        if (before == null) {
            PointMerger.$$$reportNull$$$0(1);
        }
        if (after == null) {
            PointMerger.$$$reportNull$$$0(2);
        }
        MergeClient client = this.myVcs.getFactory(this.myTarget).createMergeClient();
        SvnTarget source1 = before.toTarget();
        SvnTarget source2 = after.toTarget();
        File localPath = this.getLocalPath(after.getFullPath());
        client.merge(source1, source2, localPath, Depth.FILES, true, this.mySvnConfig.isMergeDryRun(), false, false, this.mySvnConfig.getMergeOptions(), this.myHandler);
    }

    private void delete(@NotNull SvnRepositoryContentRevision revision) throws VcsException {
        if (revision == null) {
            PointMerger.$$$reportNull$$$0(3);
        }
        DeleteClient client = this.myVcs.getFactory(this.myTarget).createDeleteClient();
        File localPath = this.getLocalPath(revision.getFullPath());
        client.delete(localPath, false, this.mySvnConfig.isMergeDryRun(), this.myHandler);
    }

    private void add(@NotNull SvnRepositoryContentRevision revision) throws VcsException {
        if (revision == null) {
            PointMerger.$$$reportNull$$$0(4);
        }
        CopyMoveClient client = this.myVcs.getFactory(this.myTarget).createCopyMoveClient();
        File localPath = this.getLocalPath(revision.getFullPath());
        client.copy(revision.toTarget(), localPath, revision.getRevisionNumber().getRevision(), true, this.myHandler);
    }

    @NotNull
    private File getLocalPath(@NotNull String fullUrl) {
        if (fullUrl == null) {
            PointMerger.$$$reportNull$$$0(5);
        }
        File file = SvnUtil.fileFromUrl(this.myTarget, this.myCurrentBranchUrl.toString(), fullUrl);
        if (file == null) {
            PointMerger.$$$reportNull$$$0(6);
        }
        return file;
    }

    @Override
    @Nullable
    public File getMergeInfoHolder() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullUrl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/PointMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/PointMerger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangesComparator
    implements Comparator<Change> {
        private static final ChangesComparator ourInstance = new ChangesComparator();

        private ChangesComparator() {
        }

        public static ChangesComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Change o1, Change o2) {
            String path2;
            String ancestor;
            SvnRepositoryContentRevision after1 = (SvnRepositoryContentRevision)o1.getAfterRevision();
            SvnRepositoryContentRevision after2 = (SvnRepositoryContentRevision)o2.getAfterRevision();
            if (after1 == null) {
                return 1;
            }
            if (after2 == null) {
                return -1;
            }
            String path1 = after1.getFullPath();
            return path1.equals(ancestor = SVNPathUtil.getCommonPathAncestor((String)path1, (String)(path2 = after2.getFullPath()))) ? -1 : 1;
        }
    }
}

