/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnHttpAuthMethodsDefaultChecker;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.svnkit.SvnKitAdminAreaFactorySelector;
import org.jetbrains.idea.svn.svnkit.SvnKitDebugLogger;
import org.jetbrains.idea.svn.svnkit.lowLevel.PrimitivePool;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SvnKitManager {
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance(SvnKitManager.class));
    @NonNls
    public static final String LOG_PARAMETER_NAME = "javasvn.log";
    @NonNls
    public static final String TRACE_NATIVE_CALLS = "javasvn.log.native";
    @NonNls
    public static final String SVNKIT_HTTP_SSL_PROTOCOLS = "svnkit.http.sslProtocols";
    @Nullable
    private static String ourExplicitlySetSslProtocols;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final SvnConfiguration myConfiguration;

    public SvnKitManager(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnKitManager.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myProject = this.myVcs.getProject();
        this.myConfiguration = this.myVcs.getSvnConfiguration();
        this.refreshSSLProperty();
    }

    @Nullable
    public static String getExplicitlySetSslProtocols() {
        return ourExplicitlySetSslProtocols;
    }

    public static boolean isSSLProtocolExplicitlySet() {
        return ourExplicitlySetSslProtocols != null;
    }

    public void refreshSSLProperty() {
        if (SvnKitManager.isSSLProtocolExplicitlySet()) {
            return;
        }
        if (SvnConfiguration.SSLProtocols.all.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.clearProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
        } else if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "SSLv3");
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)this.myConfiguration.getSslProtocols())) {
            System.setProperty(SVNKIT_HTTP_SSL_PROTOCOLS, "TLSv1");
        }
    }

    public void activate() {
        if (SystemInfo.isWindows) {
            if (!SVNJNAUtil.isJNAPresent()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no JNA", "A problem with JNA initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            } else if (!SVNJNAUtil.isWinCryptEnabled()) {
                Notifications.Bus.notify((Notification)new Notification(this.myVcs.getDisplayName(), "Subversion plugin: no encryption", "A problem with encryption module (Crypt32.dll) initialization for SVNKit library. Encryption is not available.", NotificationType.WARNING), (Project)this.myProject);
            }
        }
    }

    @NotNull
    public ISVNOptions getSvnOptions() {
        ISVNOptions iSVNOptions = this.myConfiguration.getOptions();
        if (iSVNOptions == null) {
            SvnKitManager.$$$reportNull$$$0(1);
        }
        return iSVNOptions;
    }

    @NotNull
    public SVNRepository createRepository(String url) throws SVNException {
        SVNRepository sVNRepository = this.createRepository(SVNURL.parseURIEncoded((String)url));
        if (sVNRepository == null) {
            SvnKitManager.$$$reportNull$$$0(2);
        }
        return sVNRepository;
    }

    @NotNull
    public SVNRepository createRepository(@NotNull SVNURL url) throws SVNException {
        if (url == null) {
            SvnKitManager.$$$reportNull$$$0(3);
        }
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url);
        repository.setAuthenticationManager((ISVNAuthenticationManager)this.getAuthenticationManager());
        repository.setTunnelProvider((ISVNTunnelProvider)this.getSvnOptions());
        SVNRepository sVNRepository = repository;
        if (sVNRepository == null) {
            SvnKitManager.$$$reportNull$$$0(4);
        }
        return sVNRepository;
    }

    @NotNull
    private ISVNRepositoryPool getPool() {
        ISVNRepositoryPool iSVNRepositoryPool = this.getPool((ISVNAuthenticationManager)this.getAuthenticationManager());
        if (iSVNRepositoryPool == null) {
            SvnKitManager.$$$reportNull$$$0(5);
        }
        return iSVNRepositoryPool;
    }

    @NotNull
    private ISVNRepositoryPool getPool(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            SvnKitManager.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PrimitivePool primitivePool = new PrimitivePool(manager, (ISVNTunnelProvider)this.getSvnOptions());
        if (primitivePool == null) {
            SvnKitManager.$$$reportNull$$$0(7);
        }
        return primitivePool;
    }

    @NotNull
    public SVNUpdateClient createUpdateClient() {
        SVNUpdateClient sVNUpdateClient = this.setupClient(new SVNUpdateClient(this.getPool(), this.getSvnOptions()));
        if (sVNUpdateClient == null) {
            SvnKitManager.$$$reportNull$$$0(8);
        }
        return sVNUpdateClient;
    }

    @NotNull
    public SVNUpdateClient createUpdateClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            SvnKitManager.$$$reportNull$$$0(9);
        }
        SVNUpdateClient sVNUpdateClient = SvnKitManager.setupClient(new SVNUpdateClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNUpdateClient == null) {
            SvnKitManager.$$$reportNull$$$0(10);
        }
        return sVNUpdateClient;
    }

    @NotNull
    public SVNStatusClient createStatusClient() {
        SVNStatusClient client = new SVNStatusClient(this.getPool(), this.getSvnOptions());
        client.setIgnoreExternals(false);
        SVNStatusClient sVNStatusClient = this.setupClient(client);
        if (sVNStatusClient == null) {
            SvnKitManager.$$$reportNull$$$0(11);
        }
        return sVNStatusClient;
    }

    @NotNull
    public SVNWCClient createWCClient() {
        SVNWCClient sVNWCClient = this.setupClient(new SVNWCClient(this.getPool(), this.getSvnOptions()));
        if (sVNWCClient == null) {
            SvnKitManager.$$$reportNull$$$0(12);
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNWCClient createUpgradeClient() {
        SVNWCClient sVNWCClient = new SVNWCClient(this.createOperationFactory());
        if (sVNWCClient == null) {
            SvnKitManager.$$$reportNull$$$0(13);
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNWCClient createWCClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            SvnKitManager.$$$reportNull$$$0(14);
        }
        SVNWCClient sVNWCClient = SvnKitManager.setupClient(new SVNWCClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNWCClient == null) {
            SvnKitManager.$$$reportNull$$$0(15);
        }
        return sVNWCClient;
    }

    @NotNull
    public SVNCopyClient createCopyClient() {
        SVNCopyClient sVNCopyClient = this.setupClient(new SVNCopyClient(this.getPool(), this.getSvnOptions()));
        if (sVNCopyClient == null) {
            SvnKitManager.$$$reportNull$$$0(16);
        }
        return sVNCopyClient;
    }

    @NotNull
    public SVNMoveClient createMoveClient() {
        SVNMoveClient sVNMoveClient = this.setupClient(new SVNMoveClient(this.getPool(), this.getSvnOptions()));
        if (sVNMoveClient == null) {
            SvnKitManager.$$$reportNull$$$0(17);
        }
        return sVNMoveClient;
    }

    @NotNull
    public SVNLogClient createLogClient() {
        SVNLogClient sVNLogClient = this.setupClient(new SVNLogClient(this.getPool(), this.getSvnOptions()));
        if (sVNLogClient == null) {
            SvnKitManager.$$$reportNull$$$0(18);
        }
        return sVNLogClient;
    }

    @NotNull
    public SVNLogClient createLogClient(@NotNull ISVNAuthenticationManager manager) {
        if (manager == null) {
            SvnKitManager.$$$reportNull$$$0(19);
        }
        SVNLogClient sVNLogClient = SvnKitManager.setupClient(new SVNLogClient(this.getPool(manager), this.getSvnOptions()), manager);
        if (sVNLogClient == null) {
            SvnKitManager.$$$reportNull$$$0(20);
        }
        return sVNLogClient;
    }

    @NotNull
    public SVNCommitClient createCommitClient() {
        SVNCommitClient sVNCommitClient = this.setupClient(new SVNCommitClient(this.getPool(), this.getSvnOptions()));
        if (sVNCommitClient == null) {
            SvnKitManager.$$$reportNull$$$0(21);
        }
        return sVNCommitClient;
    }

    @NotNull
    public SVNDiffClient createDiffClient() {
        SVNDiffClient sVNDiffClient = this.setupClient(new SVNDiffClient(this.getPool(), this.getSvnOptions()));
        if (sVNDiffClient == null) {
            SvnKitManager.$$$reportNull$$$0(22);
        }
        return sVNDiffClient;
    }

    @NotNull
    public SVNChangelistClient createChangelistClient() {
        SVNChangelistClient sVNChangelistClient = this.setupClient(new SVNChangelistClient(this.getPool(), this.getSvnOptions()));
        if (sVNChangelistClient == null) {
            SvnKitManager.$$$reportNull$$$0(23);
        }
        return sVNChangelistClient;
    }

    @NotNull
    public SvnOperationFactory createOperationFactory() {
        OperationFactory result = new OperationFactory();
        result.setOptions(this.getSvnOptions());
        result.setRepositoryPool(this.getPool());
        result.setAuthenticationManager((ISVNAuthenticationManager)this.getAuthenticationManager());
        OperationFactory operationFactory = result;
        if (operationFactory == null) {
            SvnKitManager.$$$reportNull$$$0(24);
        }
        return operationFactory;
    }

    @NotNull
    private SvnAuthenticationManager getAuthenticationManager() {
        SvnAuthenticationManager svnAuthenticationManager = this.myConfiguration.getAuthenticationManager(this.myVcs);
        if (svnAuthenticationManager == null) {
            SvnKitManager.$$$reportNull$$$0(25);
        }
        return svnAuthenticationManager;
    }

    @NotNull
    private <T extends SVNBasicClient> T setupClient(@NotNull T client) {
        if (client == null) {
            SvnKitManager.$$$reportNull$$$0(26);
        }
        T t = SvnKitManager.setupClient(client, (ISVNAuthenticationManager)this.getAuthenticationManager());
        if (t == null) {
            SvnKitManager.$$$reportNull$$$0(27);
        }
        return t;
    }

    @NotNull
    private static <T extends SVNBasicClient> T setupClient(@NotNull T client, @NotNull ISVNAuthenticationManager manager) {
        if (client == null) {
            SvnKitManager.$$$reportNull$$$0(28);
        }
        if (manager == null) {
            SvnKitManager.$$$reportNull$$$0(29);
        }
        client.getOperationsFactory().setAuthenticationManager(manager);
        T t = client;
        if (t == null) {
            SvnKitManager.$$$reportNull$$$0(30);
        }
        return t;
    }

    static {
        System.setProperty("svnkit.log.native.calls", "true");
        SvnKitDebugLogger logger = new SvnKitDebugLogger(Boolean.getBoolean(LOG_PARAMETER_NAME), Boolean.getBoolean(TRACE_NATIVE_CALLS), LOG);
        SVNDebugLog.setDefaultLog((ISVNDebugLog)logger);
        SVNJNAUtil.setJNAEnabled((boolean)true);
        SvnHttpAuthMethodsDefaultChecker.check();
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnKitAdminAreaFactorySelector());
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (SystemInfo.isWindows) {
            SVNAdminArea14.setOptimizedWritingEnabled((boolean)true);
        }
        if (!SVNJNAUtil.isJNAPresent()) {
            LOG.warn("JNA is not found by svnkit library");
        }
        ourExplicitlySetSslProtocols = System.getProperty(SVNKIT_HTTP_SSL_PROTOCOLS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/svnkit/SvnKitManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/svnkit/SvnKitManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvnOptions";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepository";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPool";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateClient";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatusClient";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createWCClient";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpgradeClient";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyClient";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMoveClient";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogClient";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitClient";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffClient";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangelistClient";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createOperationFactory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationManager";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setupClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRepository";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPool";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateClient";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createWCClient";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLogClient";
                break;
            }
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setupClient";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OperationFactory
    extends SvnOperationFactory {
        private OperationFactory() {
        }

        @NotNull
        public SvnUpgrade createUpgrade() {
            SvnUpgrade result = super.createUpgrade();
            result.setTargetWorkingCopyFormat(29);
            SvnUpgrade svnUpgrade = result;
            if (svnUpgrade == null) {
                OperationFactory.$$$reportNull$$$0(0);
            }
            return svnUpgrade;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/svnkit/SvnKitManager$OperationFactory", "createUpgrade"));
        }
    }
}

