/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import git4idea.DialogManager;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitSmartOperationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitSmartOperationDialog.class);
    private static final int FORCE_EXIT_CODE = 2;
    @NotNull
    private final JComponent myFileBrowser;
    @NotNull
    private final String myOperationTitle;
    @Nullable
    private final String myForceButton;

    @NotNull
    static Choice show(@NotNull Project project, @NotNull List<Change> changes, @NotNull Collection<String> paths, @NotNull String operationTitle, @Nullable String forceButtonTitle) {
        if (project == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(1);
        }
        if (paths == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(2);
        }
        if (operationTitle == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(3);
        }
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        GitSmartOperationDialog dialog = new GitSmartOperationDialog(project, (JComponent)fileBrowser, operationTitle, forceButtonTitle);
        if (fileBrowser instanceof Disposable) {
            Disposer.register((Disposable)dialog.getDisposable(), (Disposable)fileBrowser);
        }
        DialogManager.show(dialog);
        Choice choice = Choice.fromDialogExitCode(dialog.getExitCode());
        if (choice == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(4);
        }
        return choice;
    }

    private GitSmartOperationDialog(@NotNull Project project, @NotNull JComponent fileBrowser, @NotNull String operationTitle, @Nullable String forceButton) {
        if (project == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(5);
        }
        if (fileBrowser == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(6);
        }
        if (operationTitle == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(7);
        }
        super(project);
        this.myFileBrowser = fileBrowser;
        this.myOperationTitle = operationTitle;
        this.myForceButton = forceButton;
        String capitalizedOperation = StringUtil.capitalize((String)this.myOperationTitle);
        this.setTitle("Git " + capitalizedOperation + " Problem");
        this.setOKButtonText("Smart " + capitalizedOperation);
        this.getOKAction().putValue("ShortDescription", "Stash local changes, " + operationTitle + ", unstash");
        this.setCancelButtonText("Don't " + capitalizedOperation);
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        if (this.myForceButton != null) {
            Action[] actionArray = new Action[]{new ForceCheckoutAction(this.myForceButton, this.myOperationTitle)};
            if (actionArray == null) {
                GitSmartOperationDialog.$$$reportNull$$$0(8);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            GitSmartOperationDialog.$$$reportNull$$$0(9);
        }
        return actionArray;
    }

    protected JComponent createNorthPanel() {
        JBLabel description = new JBLabel("<html>Your local changes to the following files would be overwritten by " + this.myOperationTitle + ".<br/>" + ApplicationNamesInfo.getInstance().getFullProductName() + " can stash the changes, " + this.myOperationTitle + " and unstash them after that.</html>");
        description.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        return description;
    }

    protected JComponent createCenterPanel() {
        return this.myFileBrowser;
    }

    protected String getDimensionServiceKey() {
        return GitSmartOperationDialog.class.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitSmartOperationDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitSmartOperationDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ForceCheckoutAction
    extends AbstractAction {
        ForceCheckoutAction(@NotNull String buttonTitle, String operationTitle) {
            if (buttonTitle == null) {
                ForceCheckoutAction.$$$reportNull$$$0(0);
            }
            if (operationTitle == null) {
                ForceCheckoutAction.$$$reportNull$$$0(1);
            }
            super(buttonTitle);
            this.putValue("ShortDescription", StringUtil.capitalize((String)operationTitle) + " and overwrite local changes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitSmartOperationDialog.this.close(2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buttonTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operationTitle";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitSmartOperationDialog$ForceCheckoutAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Choice {
        SMART,
        FORCE,
        CANCEL;


        @NotNull
        private static Choice fromDialogExitCode(int exitCode) {
            if (exitCode == 0) {
                Choice choice = SMART;
                if (choice == null) {
                    Choice.$$$reportNull$$$0(0);
                }
                return choice;
            }
            if (exitCode == 2) {
                Choice choice = FORCE;
                if (choice == null) {
                    Choice.$$$reportNull$$$0(1);
                }
                return choice;
            }
            if (exitCode == 1) {
                Choice choice = CANCEL;
                if (choice == null) {
                    Choice.$$$reportNull$$$0(2);
                }
                return choice;
            }
            LOG.error("Unexpected exit code: " + exitCode);
            Choice choice = CANCEL;
            if (choice == null) {
                Choice.$$$reportNull$$$0(3);
            }
            return choice;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitSmartOperationDialog$Choice", "fromDialogExitCode"));
        }
    }
}

