/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import git4idea.config.GitVcsSettings;
import git4idea.util.GitCommitCompareInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class GitCompareBranchesDiffPanel
extends JPanel {
    private final String myBranchName;
    private final String myCurrentBranchName;
    private final GitCommitCompareInfo myCompareInfo;
    private final GitVcsSettings myVcsSettings;
    private final JBLabel myLabel;
    private final MyChangesBrowser myChangesBrowser;

    public GitCompareBranchesDiffPanel(Project project, String branchName, String currentBranchName, GitCommitCompareInfo compareInfo) {
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myBranchName = branchName;
        this.myVcsSettings = GitVcsSettings.getInstance(project);
        this.myLabel = new JBLabel();
        this.myChangesBrowser = new MyChangesBrowser(project, Collections.emptyList());
        HyperlinkLabel swapSidesLabel = new HyperlinkLabel("Swap branches");
        swapSidesLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = GitCompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                GitCompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                GitCompareBranchesDiffPanel.this.refreshView();
            }
        });
        JPanel topPanel = new JPanel((LayoutManager)new HorizontalLayout(JBUI.scale((int)10)));
        topPanel.add((Component)this.myLabel);
        topPanel.add((Component)swapSidesLabel);
        this.setLayout(new BorderLayout(4, 10));
        this.add((Component)topPanel, "North");
        this.add((Component)((Object)this.myChangesBrowser));
        this.refreshView();
    }

    private void refreshView() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        String currentBranchText = String.format("current working tree on <b><code>%s</code></b>", this.myCurrentBranchName);
        String otherBranchText = String.format("files in <b><code>%s</code></b>", this.myBranchName);
        this.myLabel.setText(String.format("<html>Difference between %s and %s:</html>", swapSides ? otherBranchText : currentBranchText, swapSides ? currentBranchText : otherBranchText));
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = GitCompareBranchesDiffPanel.swapRevisions(diff);
        }
        this.myChangesBrowser.setChangesToDisplay(diff);
    }

    @NotNull
    private static List<Change> swapRevisions(@NotNull List<Change> changes) {
        if (changes == null) {
            GitCompareBranchesDiffPanel.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(changes, change -> new Change(change.getAfterRevision(), change.getBeforeRevision()));
        if (list == null) {
            GitCompareBranchesDiffPanel.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitCompareBranchesDiffPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitCompareBranchesDiffPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "swapRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "swapRevisions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyChangesBrowser
    extends SimpleChangesBrowser {
        public MyChangesBrowser(@NotNull Project project, @NotNull List<Change> changes) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.setChangesToDisplay(changes);
        }

        public void setChangesToDisplay(@NotNull Collection<? extends Change> changes) {
            if (changes == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            List oldSelection = this.getSelectedChanges();
            super.setChangesToDisplay(changes);
            this.myViewer.setSelectedChanges((Collection)GitCompareBranchesDiffPanel.swapRevisions(oldSelection));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitCompareBranchesDiffPanel$MyChangesBrowser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setChangesToDisplay";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

