/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OrderEnumerator {
    public abstract OrderEnumerator productionOnly();

    public abstract OrderEnumerator compileOnly();

    public abstract OrderEnumerator runtimeOnly();

    public abstract OrderEnumerator withoutSdk();

    public abstract OrderEnumerator withoutLibraries();

    public abstract OrderEnumerator withoutDepModules();

    public abstract OrderEnumerator withoutModuleSourceEntries();

    public OrderEnumerator librariesOnly() {
        return this.withoutSdk().withoutDepModules().withoutModuleSourceEntries();
    }

    public OrderEnumerator sdkOnly() {
        return this.withoutDepModules().withoutLibraries().withoutModuleSourceEntries();
    }

    public VirtualFile[] getAllLibrariesAndSdkClassesRoots() {
        return this.withoutModuleSourceEntries().withoutDepModules().recursively().exportedOnly().classes().usingCache().getRoots();
    }

    public VirtualFile[] getAllSourceRoots() {
        return this.recursively().exportedOnly().sources().usingCache().getRoots();
    }

    public abstract OrderEnumerator recursively();

    public abstract OrderEnumerator exportedOnly();

    public abstract OrderEnumerator satisfying(Condition<OrderEntry> var1);

    public abstract OrderEnumerator using(@NotNull RootModelProvider var1);

    public abstract boolean shouldRecurse(@NotNull ModuleOrderEntry var1, @NotNull List<OrderEnumerationHandler> var2);

    public abstract OrderRootsEnumerator classes();

    public abstract OrderRootsEnumerator sources();

    public abstract OrderRootsEnumerator roots(@NotNull OrderRootType var1);

    public abstract OrderRootsEnumerator roots(@NotNull NotNullFunction<OrderEntry, OrderRootType> var1);

    public VirtualFile[] getClassesRoots() {
        return this.classes().getRoots();
    }

    public VirtualFile[] getSourceRoots() {
        return this.sources().getRoots();
    }

    public PathsList getPathsList() {
        return this.classes().getPathsList();
    }

    public PathsList getSourcePathsList() {
        return this.sources().getPathsList();
    }

    public abstract void forEach(@NotNull Processor<OrderEntry> var1);

    public abstract void forEachLibrary(@NotNull Processor<Library> var1);

    public abstract void forEachModule(@NotNull Processor<Module> var1);

    public abstract <R> R process(@NotNull RootPolicy<R> var1, R var2);

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Module module) {
        if (module == null) {
            OrderEnumerator.$$$reportNull$$$0(0);
        }
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance(module).orderEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(1);
        }
        return orderEnumerator;
    }

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Project project) {
        if (project == null) {
            OrderEnumerator.$$$reportNull$$$0(2);
        }
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance(project).orderEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(3);
        }
        return orderEnumerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/OrderEnumerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/OrderEnumerator";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "orderEntries";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

