/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    public static final ExtensionPointName<DequotingFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionDequotingFilter");

    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, Project project, Editor editor, PsiFile file2) {
        String selectedText;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && !StringUtil.isEmpty((String)(selectedText = selectionModel.getSelectedText()))) {
            TextRange replacedTextRange;
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            if (selectedText.length() > 1) {
                char firstChar = selectedText.charAt(0);
                char lastChar = selectedText.charAt(selectedText.length() - 1);
                if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && selectedText.indexOf(lastChar, 1) == selectedText.length() - 1) {
                    selectedText = selectedText.substring(1, selectedText.length() - 1);
                }
            }
            int caretOffset = selectionModel.getSelectionStart();
            char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
            String newText = String.valueOf(c) + selectedText + c2;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            boolean restoreStickySelection = editor instanceof EditorEx && ((EditorEx)editor).isStickySelection();
            selectionModel.removeSelection();
            editor.getDocument().replaceString(selectionStart, selectionEnd, (CharSequence)newText);
            TextRange textRange = replacedTextRange = Registry.is((String)"editor.smarterSelectionQuoting") ? new TextRange(caretOffset + 1, caretOffset + newText.length() - 1) : new TextRange(caretOffset, caretOffset + newText.length());
            if (replacedTextRange.getEndOffset() <= editor.getDocument().getTextLength()) {
                if (restoreStickySelection) {
                    EditorEx editorEx = (EditorEx)editor;
                    CaretModel caretModel = editorEx.getCaretModel();
                    caretModel.moveToOffset(ltrSelection ? replacedTextRange.getStartOffset() : replacedTextRange.getEndOffset());
                    editorEx.setStickySelection(true);
                    caretModel.moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                } else {
                    if (ltrSelection || editor instanceof EditorWindow) {
                        editor.getSelectionModel().setSelection(replacedTextRange.getStartOffset(), replacedTextRange.getEndOffset());
                    } else {
                        editor.getSelectionModel().setSelection(replacedTextRange.getEndOffset(), replacedTextRange.getStartOffset());
                    }
                    if (Registry.is((String)"editor.smarterSelectionQuoting")) {
                        editor.getCaretModel().moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                    }
                }
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeSelectionRemoved(c, project, editor, file2);
    }

    private static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor, String selectedText, char c) {
        for (DequotingFilter filter2 : (DequotingFilter[])Extensions.getExtensions(EP_NAME)) {
            if (!filter2.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c)) continue;
            return true;
        }
        return false;
    }

    private static char getMatchingDelimiter(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '<') {
            return '>';
        }
        return c;
    }

    private static boolean isDelimiter(char c) {
        return SelectionQuotingTypedHandler.isBracket(c) || SelectionQuotingTypedHandler.isQuote(c);
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    public static abstract class DequotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

