/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseSelectionHandler
implements CodeInsightActionHandler {
    private static final String ourPlaceHolderText = "...";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.CollapseSelectionHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(2);
        }
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            if (editor == null) {
                CollapseSelectionHandler.$$$reportNull$$$0(4);
            }
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            if (editor.getSelectionModel().hasSelection()) {
                FoldRegion region;
                int end;
                int start = editor.getSelectionModel().getSelectionStart();
                if (start + 1 >= (end = editor.getSelectionModel().getSelectionEnd())) {
                    return;
                }
                Document doc = editor.getDocument();
                if (start < end && doc.getCharsSequence().charAt(end - 1) == '\n') {
                    --end;
                }
                if ((region = FoldingUtil.findFoldRegion(editor, start, end)) != null) {
                    if (info.getPsiElement(region) == null) {
                        editor.getFoldingModel().removeFoldRegion(region);
                        info.removeRegion(region);
                    }
                } else if (!foldingModel.intersectsRegion(start, end)) {
                    region = foldingModel.addFoldRegion(start, end, ourPlaceHolderText);
                    LOG.assertTrue(region != null, (Object)("Fold region is not created. Folding model: " + foldingModel));
                    region.setExpanded(false);
                    int offset = Math.min(start + ourPlaceHolderText.length(), doc.getTextLength());
                    editor.getCaretModel().moveToOffset(offset);
                }
            } else {
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, editor.getCaretModel().getOffset());
                if (regions.length > 0) {
                    FoldRegion region = regions[0];
                    if (info.getPsiElement(region) == null) {
                        editor.getFoldingModel().removeFoldRegion(region);
                        info.removeRegion(region);
                    } else {
                        region.setExpanded(!region.isExpanded());
                    }
                }
            }
        });
    }

    public static boolean isEnabled(@NotNull Editor editor) {
        if (editor == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(3);
        }
        if (editor.getSelectionModel().hasSelection()) {
            FoldRegion region;
            int end;
            int start = editor.getSelectionModel().getSelectionStart();
            if (start + 1 >= (end = editor.getSelectionModel().getSelectionEnd())) {
                return false;
            }
            if (start < end && editor.getDocument().getCharsSequence().charAt(end - 1) == '\n') {
                --end;
            }
            if ((region = FoldingUtil.findFoldRegion(editor, start, end)) == null) {
                return !((FoldingModelEx)editor.getFoldingModel()).intersectsRegion(start, end);
            }
            return EditorFoldingInfo.get(editor).getPsiElement(region) == null;
        }
        return FoldingUtil.getFoldRegionsAtOffset(editor, editor.getCaretModel().getOffset()).length > 0;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

