/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TerminateRemoteProcessDialog {
    public static GeneralSettings.ProcessCloseConfirmation show(Project project, String sessionName, ProcessHandler processHandler2) {
        if (processHandler2.isSilentlyDestroyOnClose() || Boolean.TRUE.equals(processHandler2.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
            return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
        }
        final boolean canDisconnect = !Boolean.TRUE.equals(processHandler2.getUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY));
        GeneralSettings.ProcessCloseConfirmation confirmation = GeneralSettings.getInstance().getProcessCloseConfirmation();
        if (confirmation != GeneralSettings.ProcessCloseConfirmation.ASK) {
            if (confirmation == GeneralSettings.ProcessCloseConfirmation.DISCONNECT && !canDisconnect) {
                confirmation = GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            }
            return confirmation;
        }
        ArrayList<String> options = new ArrayList<String>(3);
        options.add(ExecutionBundle.message((String)"button.terminate", (Object[])new Object[0]));
        if (canDisconnect) {
            options.add(ExecutionBundle.message((String)"button.disconnect", (Object[])new Object[0]));
        }
        options.add(CommonBundle.getCancelButtonText());
        DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                GeneralSettings.ProcessCloseConfirmation confirmation;
                if (isSelected && (confirmation = TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect)) != null) {
                    GeneralSettings.getInstance().setProcessCloseConfirmation(confirmation);
                }
            }
        };
        final AtomicBoolean alreadyGone = new AtomicBoolean(false);
        final Runnable dialogRemover = Messages.createMessageDialogRemover((Project)project);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                alreadyGone.set(true);
                dialogRemover.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/TerminateRemoteProcessDialog$2", "processWillTerminate"));
            }
        };
        processHandler2.addProcessListener((ProcessListener)listener2);
        boolean defaultDisconnect = processHandler2.detachIsDefault();
        int exitCode = Messages.showDialog((Project)project, (String)ExecutionBundle.message((String)"terminate.process.confirmation.text", (Object[])new Object[]{sessionName}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{sessionName}), (String[])ArrayUtil.toStringArray(options), (int)(canDisconnect && defaultDisconnect ? 1 : 0), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
        processHandler2.removeProcessListener((ProcessListener)listener2);
        if (alreadyGone.get()) {
            return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
        }
        return TerminateRemoteProcessDialog.getConfirmation(exitCode, canDisconnect);
    }

    private static GeneralSettings.ProcessCloseConfirmation getConfirmation(int button, boolean withDisconnect) {
        switch (button) {
            case 0: {
                return GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            }
            case 1: {
                if (!withDisconnect) break;
                return GeneralSettings.ProcessCloseConfirmation.DISCONNECT;
            }
        }
        return null;
    }
}

