/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunConfigurationNode
extends AbstractTreeNode<Pair<RunnerAndConfigurationSettings, Content>>
implements RunDashboardRunConfigurationNode {
    @Nullable
    private final RunDashboardContributor myContributor;
    private final UserDataHolder myUserDataHolder;

    RunConfigurationNode(Project project, @NotNull Pair<RunnerAndConfigurationSettings, RunContentDescriptor> value, @Nullable RunDashboardContributor contributor) {
        if (value == null) {
            RunConfigurationNode.$$$reportNull$$$0(0);
        }
        super(project, (Object)Pair.create((Object)value.first, value.second == null ? null : ((RunContentDescriptor)value.second).getAttachedContent()));
        this.myUserDataHolder = new UserDataHolderBase();
        this.myContributor = contributor;
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)((Pair)this.getValue()).first;
        if (runnerAndConfigurationSettings == null) {
            RunConfigurationNode.$$$reportNull$$$0(1);
        }
        return runnerAndConfigurationSettings;
    }

    @Nullable
    public RunContentDescriptor getDescriptor() {
        Content content = this.getContent();
        if (content == null) {
            return null;
        }
        return RunContentManagerImpl.getRunContentDescriptorByContent(content);
    }

    @Nullable
    public Content getContent() {
        return (Content)((Pair)this.getValue()).second;
    }

    protected void update(PresentationData presentation) {
        RunnerAndConfigurationSettings configurationSettings = this.getConfigurationSettings();
        boolean isStored = RunManager.getInstance((Project)this.getProject()).hasSettings(configurationSettings);
        SimpleTextAttributes nameAttributes = isStored ? (this.getContent() != null ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES) : SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        presentation.addText(configurationSettings.getName(), nameAttributes);
        Icon icon = null;
        RunDashboardRunConfigurationStatus status = this.getStatus();
        if (RunDashboardRunConfigurationStatus.STARTED.equals(status)) {
            icon = this.getExecutorIcon();
        } else if (RunDashboardRunConfigurationStatus.FAILED.equals(status)) {
            icon = status.getIcon();
        }
        if (icon == null) {
            icon = RunManagerEx.getInstanceEx(this.getProject()).getConfigurationIcon(configurationSettings);
        }
        presentation.setIcon(isStored ? icon : IconLoader.getDisabledIcon((Icon)icon));
        if (this.myContributor != null) {
            this.myContributor.updatePresentation(presentation, (RunDashboardNode)this);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            RunConfigurationNode.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            RunConfigurationNode.$$$reportNull$$$0(3);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            RunConfigurationNode.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @Nullable
    public RunDashboardContributor getContributor() {
        return this.myContributor;
    }

    @NotNull
    public RunDashboardRunConfigurationStatus getStatus() {
        RunDashboardRunConfigurationStatus runDashboardRunConfigurationStatus = this.myContributor != null ? this.myContributor.getStatus((RunDashboardRunConfigurationNode)this) : RunDashboardRunConfigurationStatus.getStatus((RunDashboardRunConfigurationNode)this);
        if (runDashboardRunConfigurationStatus == null) {
            RunConfigurationNode.$$$reportNull$$$0(5);
        }
        return runDashboardRunConfigurationStatus;
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        Content content = this.getContent();
        if (content != null && !RunContentManagerImpl.isTerminated(content) && (executor = RunContentManagerImpl.getExecutorByContent(content)) != null) {
            return executor.getIcon();
        }
        return null;
    }

    public String toString() {
        return this.getConfigurationSettings().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/tree/RunConfigurationNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/tree/RunConfigurationNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

